/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.config.gui.ModOptionList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigFields {
    @Nullable
    private static Map<String, String> defaultLanguageKeys = null;
    private final File file;
    private final List<Field<?>> fields = new ArrayList();
    private final Map<String, Field<?>> fieldMap = new HashMap();
    private final Set<Field<?>> fieldSet = new HashSet();

    public ConfigFields(String filename) {
        this.file = new File(Minecraft.getInstance().gameDirectory, "config/" + filename);
    }

    public IntegerField add(String name, int val) {
        IntegerField field = new IntegerField(name, val);
        this.addField(field, name);
        return field;
    }

    public BooleanField add(String name, boolean val) {
        BooleanField field = new BooleanField(name, val);
        this.addField(field, name);
        return field;
    }

    private void addField(Field<?> field, String name) {
        this.fields.add(field);
        if (this.fieldMap.put(name, field) != null) {
            throw new RuntimeException("Duplicate field names!");
        }
        if (!this.fieldSet.add(field)) {
            throw new RuntimeException("Duplicate fields!");
        }
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));){
            this.fields.forEach(field -> field.save(writer));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void load() {
        int loadedCount = 0;
        boolean rewrite = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || StringUtils.isBlank((CharSequence)line)) continue;
                int equalSignPos = line.indexOf(61);
                if (equalSignPos == -1) {
                    throw new IOException();
                }
                String name = line.substring(0, equalSignPos).trim();
                String value = line.substring(equalSignPos + 1).trim();
                Field<?> field = this.fieldMap.get(name);
                if (field == null) {
                    rewrite = true;
                    continue;
                }
                field.load(value);
                ++loadedCount;
            }
        }
        catch (IOException exception) {
            this.save();
        }
        if (loadedCount != this.fields.size() || rewrite) {
            this.save();
        }
    }

    public void reset() {
        this.fields.forEach(Field::reset);
    }

    private static void loadDefaultLanguageKeys() {
        defaultLanguageKeys = new HashMap<String, String>();
        try (InputStream stream = NBTac.class.getResourceAsStream(String.format("/assets/%s/lang/en_us.json", "nbt_ac"));){
            if (stream == null) {
                return;
            }
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
            Pattern replacePattern = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
            for (Map.Entry entry : json.entrySet()) {
                String str = replacePattern.matcher(GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                defaultLanguageKeys.put((String)entry.getKey(), str);
            }
        }
        catch (JsonParseException | IOException exception) {
            NBTac.LOGGER.error("Failed to load default language keys!");
        }
    }

    public static class IntegerField
    extends Field<Integer> {
        public IntegerField(String name, Integer val) {
            super(name, val);
        }

        @Override
        public void fromString(String str) {
            this.val = Integer.valueOf(str);
        }

        public AbstractWidget createSwitch(List<Integer> options) {
            return new ModOptionList.IntegerSwitch(this, options);
        }

        public AbstractWidget createSlider(int min, int max, int multiplier, @Nullable List<Integer> specialValues) {
            return new ModOptionList.IntegerSlider(this, min, max, multiplier, specialValues);
        }
    }

    public static abstract class Field<T> {
        private static final String NAME_KEY_PREFIX = "nbt_ac.options.field.";
        private static final String DESC_KEY_SUFFIX = ".desc";
        private static final String DESC_ERROR = "[failed to load description]";
        public final String name;
        private final T defVal;
        public volatile T val;

        protected Field(String name, T val) {
            this.name = name;
            this.val = val;
            this.defVal = val;
        }

        protected void save(PrintWriter writer) {
            String description = String.format("%s\nDefault value: %s", this.getDefaultDescription(), this);
            BufferedReader reader = new BufferedReader(new StringReader(description));
            reader.lines().forEach(line -> writer.println("# " + line));
            writer.printf("%s = %s\n\n", this.name, this);
        }

        protected void load(String str) throws IOException {
            try {
                this.fromString(str);
            }
            catch (NumberFormatException exception) {
                throw new IOException();
            }
        }

        public void reset() {
            this.val = this.defVal;
        }

        public String toString() {
            return this.val.toString();
        }

        public Component getWidgetName() {
            return Component.translatable((String)(NAME_KEY_PREFIX + this.name));
        }

        public String getWidgetNameKey() {
            return NAME_KEY_PREFIX + this.name;
        }

        public Component getWidgetTooltip() {
            return Component.translatable((String)"nbt_ac.options.common.tooltip", (Object[])new Object[]{Component.translatable((String)this.getDescriptionKey()), this.defVal.toString()});
        }

        private String getDefaultDescription() {
            if (defaultLanguageKeys == null) {
                ConfigFields.loadDefaultLanguageKeys();
            }
            return defaultLanguageKeys.getOrDefault(this.getDescriptionKey(), DESC_ERROR);
        }

        private String getDescriptionKey() {
            return NAME_KEY_PREFIX + this.name + DESC_KEY_SUFFIX;
        }

        abstract void fromString(String var1);
    }

    public static class BooleanField
    extends Field<Boolean> {
        public BooleanField(String name, Boolean val) {
            super(name, val);
        }

        @Override
        public void fromString(String str) {
            this.val = Boolean.valueOf(str);
        }

        public AbstractWidget createSwitch() {
            return new ModOptionList.BooleanSwitch(this, false);
        }

        public AbstractWidget createDescribedSwitch() {
            return new ModOptionList.BooleanSwitch(this, true);
        }
    }
}

