/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.config.gui;

import com.mt1006.nbt_ac.config.ConfigFields;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModOptionList
extends ContainerObjectSelectionList<ListWidget> {
    protected static final int ELEMENT_WIDTH = 310;
    protected static final int ELEMENT_HEIGHT = 20;
    private final Font font;
    private final List<MutableWidget> mutableWidgets = new ArrayList<MutableWidget>();

    public ModOptionList(Minecraft minecraft, int w, int h, int yTop, int itemHeight, Font font) {
        super(minecraft, w, h, yTop, itemHeight);
        this.font = font;
    }

    public void addLabel(String key) {
        this.addWidget((AbstractWidget)new Label(this.width, 9, (Component)Component.translatable((String)("nbt_ac.options." + key)), this.font));
    }

    public void add(AbstractWidget widget) {
        widget.setX(this.width / 2 - 155);
        this.addWidget(widget);
    }

    private void addWidget(AbstractWidget widget) {
        this.addEntry((AbstractSelectionList.Entry)new ListWidget(widget));
        if (widget instanceof MutableWidget) {
            this.mutableWidgets.add((MutableWidget)widget);
        }
    }

    public void updateValues() {
        this.mutableWidgets.forEach(MutableWidget::update);
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    private static class Label
    extends StringWidget {
        private final int yOffset;

        public Label(int w, int yOffset, Component component, Font font) {
            super(w, 9, component, font);
            this.yOffset = yOffset;
        }

        public int getY() {
            return super.getY() + this.yOffset;
        }
    }

    protected static class ListWidget
    extends ContainerObjectSelectionList.Entry<ListWidget> {
        private final AbstractWidget widget;

        private ListWidget(AbstractWidget widget) {
            this.widget = widget;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.widget);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widget);
        }

        public void render(@NotNull GuiGraphics guiGraphics, int a, int b, int c, int d, int e, int mouseX, int mouseY, boolean h, float i) {
            this.widget.setY(b);
            this.widget.render(guiGraphics, mouseX, mouseY, i);
        }
    }

    public static interface MutableWidget {
        public void update();
    }

    public static class IntegerSlider
    extends AbstractSlider<Integer, Integer> {
        private final int multiplier;
        @Nullable
        private final List<Integer> specialValues;

        public IntegerSlider(ConfigFields.IntegerField field, int min, int max, int multiplier, @Nullable List<Integer> specialValues) {
            super(field, min, max);
            this.multiplier = multiplier;
            this.specialValues = specialValues;
            this.update();
        }

        @Override
        protected void updateSliderValue() {
            float diff = (Integer)this.max - (Integer)this.min;
            int valPos = (Integer)this.field.val / this.multiplier;
            this.value = valPos < (Integer)this.max ? (double)Mth.clamp((float)(((float)valPos - (float)((Integer)this.min).intValue()) / diff), (float)0.0f, (float)1.0f) : 1.0;
        }

        protected void applyValue() {
            int steps = (Integer)this.max - (Integer)this.min + 1;
            int pos = Math.min((int)(this.value * (double)steps), steps - 1);
            this.field.val = ((Integer)this.min + pos) * this.multiplier;
        }

        protected void updateMessage() {
            int valPos = (Integer)this.field.val / this.multiplier;
            MutableComponent subcomponent = this.specialValues != null && this.specialValues.contains(valPos) ? Component.translatable((String)String.format("%s.%d", this.widgetNameKey.get(), valPos)) : Component.literal((String)Integer.toString((Integer)this.field.val));
            this.setMessage((Component)this.component.copy().append(": ").append((Component)subcomponent));
        }

        @Override
        public void update() {
            this.updateSliderValue();
            this.updateMessage();
        }
    }

    private static abstract class AbstractSlider<T, V extends Comparable<V>>
    extends AbstractSliderButton
    implements MutableWidget {
        protected final ConfigFields.Field<T> field;
        protected final Component component;
        protected final V min;
        protected final V max;
        protected final Supplier<String> widgetNameKey;

        public AbstractSlider(ConfigFields.Field<T> field, V min, V max) {
            super(0, 0, 310, 20, CommonComponents.EMPTY, 0.0);
            this.field = field;
            this.component = field.getWidgetName();
            this.min = min;
            this.max = max;
            this.widgetNameKey = field::getWidgetNameKey;
            if (min.compareTo(max) > 0) {
                throw new RuntimeException("Slider - min bigger than max!");
            }
            this.setTooltip(Tooltip.create((Component)field.getWidgetTooltip()));
        }

        @Override
        public void update() {
            this.updateSliderValue();
            this.updateMessage();
        }

        protected abstract void updateSliderValue();
    }

    public static class IntegerSwitch
    extends AbstractButton
    implements MutableWidget {
        private static final Component UNDEFINED_OPTION = Component.translatable((String)"nbt_ac.options.common.undefined");
        private final ConfigFields.IntegerField field;
        private final String key;
        private final List<Integer> options;
        private final Component component;

        public IntegerSwitch(ConfigFields.IntegerField field, List<Integer> options) {
            super(0, 0, 310, 20, CommonComponents.EMPTY);
            this.field = field;
            this.key = field.getWidgetNameKey();
            this.options = options;
            this.component = Component.translatable((String)this.key);
            this.updateText();
            this.setTooltip(Tooltip.create((Component)field.getWidgetTooltip()));
        }

        public void updateText() {
            Component optionComponent = this.options.contains(this.field.val) ? Component.translatable((String)String.format("%s.%d", this.key, this.field.val)) : UNDEFINED_OPTION;
            this.setMessage((Component)this.component.copy().append(": ").append(optionComponent));
        }

        public void onPress() {
            int pos = this.options.indexOf(this.field.val);
            int newIndex = pos != this.options.size() - 1 ? pos + 1 : 0;
            this.field.val = this.options.get(newIndex);
            this.updateText();
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationOutput) {
            this.defaultButtonNarrationText(narrationOutput);
        }

        @Override
        public void update() {
            this.updateText();
        }
    }

    public static class BooleanSwitch
    extends AbstractButton
    implements MutableWidget {
        private final ConfigFields.BooleanField field;
        private final Component component;
        private final Component valOn;
        private final Component valOff;

        public BooleanSwitch(ConfigFields.BooleanField field, boolean useCustomValues) {
            super(0, 0, 310, 20, CommonComponents.EMPTY);
            this.field = field;
            this.component = field.getWidgetName();
            this.valOn = useCustomValues ? Component.translatable((String)(field.getWidgetNameKey() + ".true")) : CommonComponents.OPTION_ON;
            this.valOff = useCustomValues ? Component.translatable((String)(field.getWidgetNameKey() + ".false")) : CommonComponents.OPTION_OFF;
            this.updateText();
            this.setTooltip(Tooltip.create((Component)field.getWidgetTooltip()));
        }

        public void updateText() {
            Component val = (Boolean)this.field.val != false ? this.valOn : this.valOff;
            this.setMessage((Component)this.component.copy().append(": ").append(val));
        }

        public void onPress() {
            this.field.val = (Boolean)this.field.val == false;
            this.updateText();
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationOutput) {
            this.defaultButtonNarrationText(narrationOutput);
        }

        @Override
        public void update() {
            this.updateText();
        }
    }
}

