/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.LycheeFallingBlockEntity;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record AnvilDamageChance(PostActionCommonProperties commonProperties, float chance) implements PostAction
{
    public PostActionType<AnvilDamageChance> type() {
        return PostActionTypes.ANVIL_DAMAGE_CHANCE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Entity entity = (Entity)lootParams.get(LootContextParams.THIS_ENTITY);
        if (entity instanceof LycheeFallingBlockEntity) {
            LycheeFallingBlockEntity fallingBlockEntity = (LycheeFallingBlockEntity)entity;
            fallingBlockEntity.lychee$anvilDamageChance(this.chance);
        }
    }

    @Override
    public boolean hidden() {
        return true;
    }

    public static class Type
    implements PostActionType<AnvilDamageChance> {
        public static final MapCodec<AnvilDamageChance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(AnvilDamageChance::commonProperties), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(AnvilDamageChance::chance)).apply((Applicative)instance, AnvilDamageChance::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnvilDamageChance> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, AnvilDamageChance::commonProperties, (StreamCodec)ByteBufCodecs.FLOAT, AnvilDamageChance::chance, AnvilDamageChance::new);

        @Override
        public MapCodec<AnvilDamageChance> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AnvilDamageChance> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

