/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.brigadier.ParseResults;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Execute(PostActionCommonProperties commonProperties, String command, boolean repeat) implements PostAction
{
    public static final Component DEFAULT_NAME = Component.literal((String)"lychee");

    public PostActionType<Execute> type() {
        return PostActionTypes.EXECUTE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams;
        Vec3 pos;
        if (this.command.isEmpty()) {
            return;
        }
        if (!this.repeat) {
            times = 1;
        }
        if ((pos = (Vec3)(lootParams = context.get(LycheeContextKey.LOOT_PARAMS)).getOrNull(LootContextParams.ORIGIN)) == null) {
            pos = Vec3.ZERO;
        }
        Entity entity = (Entity)lootParams.getOrNull(LootContextParams.THIS_ENTITY);
        Vec2 rotation = Vec2.ZERO;
        Component displayName = DEFAULT_NAME;
        String name = "lychee";
        if (entity != null) {
            rotation = entity.getRotationVector();
            displayName = entity.getDisplayName();
            name = entity.getName().getString();
        }
        ServerLevel level = (ServerLevel)context.level();
        CommandSourceStack commandSourceStack = new CommandSourceStack(CommandSource.NULL, pos, rotation, level, 2, name, displayName, level.getServer(), entity);
        for (int i = 0; i < times; ++i) {
            Commands commands = level.getServer().getCommands();
            ParseResults parseResults = commands.getDispatcher().parse(this.command, (Object)commandSourceStack);
            commands.performCommand(parseResults, this.command);
        }
    }

    @Override
    public boolean preventSync() {
        return this.hidden();
    }

    public static class Type
    implements PostActionType<Execute> {
        public static final MapCodec<Execute> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(Execute::commonProperties), (App)Codec.STRING.fieldOf("command").forGetter(Execute::command), (App)Codec.BOOL.optionalFieldOf("repeat", (Object)true).forGetter(Execute::repeat)).apply((Applicative)instance, Execute::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Execute> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, Execute::commonProperties, properties -> new Execute((PostActionCommonProperties)properties, "", false));

        @Override
        public MapCodec<Execute> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Execute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

