/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record PlaceBlock(PostActionCommonProperties commonProperties, BlockPredicate block, BlockPos offset, boolean fancyDisplay) implements PostAction
{
    public PlaceBlock(PostActionCommonProperties properties, BlockPredicate block, BlockPos offset) {
        this(properties, block, offset, properties.icon() == null && BlockPredicateExtensions.isAny(block) && offset.equals((Object)BlockPos.ZERO));
    }

    private static void destroyBlock(Level level, BlockPos pos, boolean drop) {
        boolean flag;
        BlockState legacy;
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.isAir()) {
            return;
        }
        FluidState fluidstate = level.getFluidState(pos);
        if (!(blockstate.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, pos, Block.getId((BlockState)blockstate));
        }
        if (drop) {
            BlockEntity blockentity = blockstate.hasBlockEntity() ? level.getBlockEntity(pos) : null;
            Block.dropResources((BlockState)blockstate, (Level)level, (BlockPos)pos, (BlockEntity)blockentity, null, (ItemStack)ItemStack.EMPTY);
        }
        if ((legacy = fluidstate.createLegacyBlock()) == blockstate) {
            legacy = Blocks.AIR.defaultBlockState();
        }
        if (flag = level.setBlock(pos, legacy, 3, 512)) {
            level.gameEvent(null, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
    }

    public PostActionType<? extends PlaceBlock> type() {
        return PostActionTypes.PLACE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        BlockEntity blockEntity;
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        BlockPos pos = lootParams.get(LycheeLootContextParams.BLOCK_POS).offset((Vec3i)this.offset);
        Level level = context.level();
        BlockState oldState = level.getBlockState(pos);
        BlockState blockState = BlockPredicateExtensions.anyBlockState(this.block);
        if (blockState.isAir()) {
            PlaceBlock.destroyBlock(level, pos, false);
            return;
        }
        if (recipe instanceof BlockCrushingRecipe && !oldState.isAir()) {
            level.levelEvent(2001, pos, Block.getId((BlockState)oldState));
        }
        Set properties = this.block.properties().map(StatePropertiesPredicate::properties).stream().flatMap(Collection::stream).map(StatePropertiesPredicate.PropertyMatcher::name).collect(Collectors.toSet());
        for (Map.Entry entry : oldState.getValues().entrySet()) {
            Property property = (Property)entry.getKey();
            if (properties.contains(property.getName())) continue;
            blockState = (BlockState)blockState.trySetValue(property, (Comparable)entry.getValue());
        }
        if (oldState.getFluidState().isSourceOfType((Fluid)Fluids.WATER)) {
            blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        if (!level.setBlockAndUpdate(pos, blockState)) {
            return;
        }
        if (this.block.nbt().isPresent() && (blockEntity = level.getBlockEntity(pos)) != null && !blockEntity.onlyOpCanSetNbt()) {
            CompoundTag prevTag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            CompoundTag originalTag = prevTag.copy();
            prevTag.merge(((NbtPredicate)this.block.nbt().get()).tag());
            if (!prevTag.equals((Object)originalTag)) {
                blockEntity.loadWithComponents(prevTag, (HolderLookup.Provider)level.registryAccess());
                blockEntity.setChanged();
            }
        }
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
    }

    @Override
    public Component getDisplayName() {
        BlockState state = BlockPredicateExtensions.anyBlockState(this.block);
        String key = CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(PostActionTypes.PLACE));
        if (state.isAir()) {
            return Component.translatable((String)(key + ".consume"));
        }
        return Component.translatable((String)key, (Object[])new Object[]{state.getBlock().getName()});
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return BlockPredicateExtensions.matchedItemStacks(this.block);
    }

    @Override
    public List<BlockPredicate> getOutputBlocks() {
        return BlockPredicateExtensions.isAny(this.block) ? List.of() : List.of(this.block);
    }

    @Override
    public boolean hidden() {
        return this.fancyDisplay() || PostAction.super.hidden();
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    public static class Type
    implements PostActionType<PlaceBlock> {
        public static final MapCodec<PlaceBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(PlaceBlock::commonProperties), (App)BlockPredicateExtensions.CODEC.fieldOf("block").forGetter(PlaceBlock::block), (App)LycheeCodecs.OFFSET.forGetter(PlaceBlock::offset)).apply((Applicative)instance, PlaceBlock::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlaceBlock> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, PlaceBlock::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, PlaceBlock::block, (StreamCodec)BlockPos.STREAM_CODEC, PlaceBlock::offset, PlaceBlock::new);

        @Override
        public MapCodec<PlaceBlock> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, PlaceBlock> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

