/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.category;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.jei.element.RenderElementAdapter;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class CraftingRecipeCategoryExtension
implements ICraftingCategoryExtension<ShapedCraftingRecipe> {
    private static final Vector2fc INFO_POSITION = new Vector2f(67.0f, 11.0f);

    public int getWidth(RecipeHolder<ShapedCraftingRecipe> recipeHolder) {
        return ((ShapedCraftingRecipe)recipeHolder.value()).getWidth();
    }

    public int getHeight(RecipeHolder<ShapedCraftingRecipe> recipeHolder) {
        return ((ShapedCraftingRecipe)recipeHolder.value()).getHeight();
    }

    public void createRecipeExtras(RecipeHolder<ShapedCraftingRecipe> recipeHolder, IRecipeExtrasBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        if (RvCategory.needInfo((ILycheeRecipe)recipeHolder.value())) {
            builder.addWidget((IRecipeWidget)new RenderElementAdapter((RenderElement)RvCategory.infoIcon(recipeHolder).at(INFO_POSITION)));
        }
    }

    public void setRecipe(RecipeHolder<ShapedCraftingRecipe> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        ShapedCraftingRecipe craftingRecipe = (ShapedCraftingRecipe)recipeHolder.value();
        List<List> inputs = craftingRecipe.getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        ItemStack resultItem = craftingRecipe.getResultItem((HolderLookup.Provider)Objects.requireNonNull(Minecraft.getInstance().level).registryAccess());
        int width = this.getWidth(recipeHolder);
        int height = this.getHeight(recipeHolder);
        craftingGridHelper.createAndSetOutputs(builder, List.of(resultItem));
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }
}

