/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record IsDifficulty(List<Difficulty> difficulties) implements ContextualCondition
{
    public ContextualConditionType<IsDifficulty> type() {
        return ContextualConditionType.DIFFICULTY;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.difficulties.contains(ctx.level().getDifficulty()) ? times : 0;
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        return TriState.of((boolean)this.difficulties.contains(level.getDifficulty()));
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        Object key = this.getDescriptionId(inverted);
        int size = this.difficulties.size();
        if (size == 1) {
            return Component.translatable((String)key, (Object[])new Object[]{this.difficulties.getFirst().getDisplayName().copy().withStyle(ChatFormatting.WHITE)});
        }
        key = (String)key + ".more";
        List<MutableComponent> components = this.difficulties.stream().map(it -> it.getDisplayName().copy().withStyle(ChatFormatting.WHITE)).toList();
        MutableComponent component = Component.empty().append((Component)components.getFirst());
        for (int i = 1; i < size - 1; ++i) {
            component.append(", ");
            component.append((Component)components.get(i));
        }
        return Component.translatable((String)key, (Object[])new Object[]{component, components.get(size - 1)});
    }

    public static class Type
    implements ContextualConditionType<IsDifficulty> {
        public static final Codec<Difficulty> DIFFICULTY_CODEC = Codec.withAlternative((Codec)Difficulty.CODEC, (Codec)ExtraCodecs.NON_NEGATIVE_INT.xmap(Difficulty::byId, Difficulty::getId));
        public static final MapCodec<IsDifficulty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)KCodecs.compactList(DIFFICULTY_CODEC)).fieldOf("difficulty").forGetter(IsDifficulty::difficulties)).apply((Applicative)instance, IsDifficulty::new));
        public static final StreamCodec<ByteBuf, Difficulty> DIFFICULTY_STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)Difficulty.BY_ID, Difficulty::getId);
        public static final StreamCodec<ByteBuf, IsDifficulty> STREAM_CODEC = DIFFICULTY_STREAM_CODEC.apply(ByteBufCodecs.list()).map(IsDifficulty::new, IsDifficulty::difficulties);

        @Override
        public MapCodec<IsDifficulty> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, IsDifficulty> streamCodec() {
            return STREAM_CODEC.cast();
        }
    }
}

