/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Time(MinMaxBounds.Ints value, Optional<Long> period) implements ContextualCondition
{
    public ContextualConditionType<Time> type() {
        return ContextualConditionType.TIME;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.test((LevelAccessor)ctx.level()) ? times : 0;
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        return TriState.of((boolean)this.test((LevelAccessor)level));
    }

    public boolean test(LevelAccessor level) {
        long i = level.dayTime();
        if (this.period.isPresent()) {
            i %= this.period.get().longValue();
        }
        return this.value.matches((int)i);
    }

    public static class Type
    implements ContextualConditionType<Time> {
        public static final MapCodec<Time> CODEC = TimeCheck.CODEC.flatXmap(it -> {
            if (it.value().min == null || it.value().min.getType() != NumberProviders.CONSTANT) {
                return DataResult.error(() -> "`min` not exists or not a constant");
            }
            if (it.value().max == null || it.value().max.getType() != NumberProviders.CONSTANT) {
                return DataResult.error(() -> "`max` not exists or not a constant");
            }
            return DataResult.success((Object)new Time(MinMaxBounds.Ints.between((int)it.value().min.getInt(null), (int)it.value().max.getInt(null)), it.period()));
        }, it -> {
            TimeCheck.Builder builder = TimeCheck.time((IntRange)IntRange.range((int)((Integer)it.value().min().orElseThrow()), (int)((Integer)it.value().max().orElseThrow())));
            it.period.ifPresent(arg_0 -> ((TimeCheck.Builder)builder).setPeriod(arg_0));
            return DataResult.success((Object)builder.build());
        });

        @Override
        public MapCodec<Time> codec() {
            return CODEC;
        }
    }
}

