/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.datagen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.serialization.RecordBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;
import snownee.lychee.action.RandomSelect;
import snownee.lychee.datagen.ContextualBuilder;
import snownee.lychee.datagen.LycheeBuilder;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionLike;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;

@NotNullByDefault
public class ActionBuilder<T extends ActionBuilder<T, R>, R extends PostAction>
extends ContextualBuilder<T>
implements PostActionLike {
    @Nullable
    protected R action;
    @Nullable
    protected ResourceLocation icon;

    public ActionBuilder() {
    }

    public ActionBuilder(R action) {
        this.action = action;
    }

    @Contract(value="-> this")
    public T hide() {
        return this.icon(PostActionCommonProperties.HIDDEN);
    }

    @Contract(value="_ -> this")
    public T icon(ResourceLocation icon) {
        this.icon = icon;
        return (T)((ActionBuilder)this.self());
    }

    public boolean isModified() {
        return this.icon != null || !this.conditions.isEmpty();
    }

    public R build() {
        Objects.requireNonNull(this.action);
        if (!this.isModified()) {
            return this.action;
        }
        RegistryOps<Object> ops = Objects.requireNonNull(LycheeBuilder.registryOps.get());
        RecordBuilder builder = ops.mapBuilder();
        PostAction.MAP_CODEC.encode(this.action, ops, builder);
        if (this.icon != null) {
            PostActionCommonProperties.ICON_CODEC.encode(Optional.of(this.icon), ops, builder);
            this.icon = null;
        }
        if (!this.conditions.isEmpty()) {
            LycheeRecipeCommonProperties.CONTEXTUAL_CODEC.encode((Object)this.contextualHolder(), ops, builder);
            this.conditions.clear();
        }
        this.action = (PostAction)PostAction.MAP_CODEC.compressedDecode(ops, builder.build(ops.empty()).getOrThrow()).getOrThrow();
        return this.action;
    }

    @Override
    public PostAction asAction() {
        return this.build();
    }

    public static class RandomSelectBuilder
    extends ActionBuilder<RandomSelectBuilder, RandomSelect> {
        private final List<RandomSelect.Entry> entries = Lists.newArrayList();
        private int emptyWeight;
        private MinMaxBounds.Ints rolls = BoundsExtensions.ONE;

        @Contract(value="_, _ -> this")
        public RandomSelectBuilder post(PostActionLike postAction, int weight) {
            Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be positive");
            this.entries.add(new RandomSelect.Entry(postAction.asAction(), weight));
            return (RandomSelectBuilder)this.self();
        }

        @Contract(value="_ -> this")
        public RandomSelectBuilder emptyWeight(int emptyWeight) {
            this.emptyWeight = emptyWeight;
            return (RandomSelectBuilder)this.self();
        }

        @HideFromJS
        @Contract(value="_ -> this")
        public RandomSelectBuilder rolls(MinMaxBounds.Ints rolls) {
            this.rolls = rolls;
            return (RandomSelectBuilder)this.self();
        }

        @Contract(value="_ -> this")
        public RandomSelectBuilder rolls(int rolls) {
            return this.rolls(MinMaxBounds.Ints.exactly((int)rolls));
        }

        @Contract(value="_, _ -> this")
        public RandomSelectBuilder rolls(int min, int max) {
            return this.rolls(MinMaxBounds.Ints.between((int)min, (int)max));
        }

        @Override
        public RandomSelect build() {
            this.action = new RandomSelect(PostActionCommonProperties.EMPTY, this.entries, this.emptyWeight, this.rolls);
            return (RandomSelect)super.build();
        }

        @Override
        public boolean isModified() {
            return true;
        }
    }
}

