/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin.recipes.blockexploding;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockExplodingRecipe;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ItemStackHolderCollection;

@Mixin(value={Explosion.class}, priority=700)
public abstract class ExplosionMixin {
    @Final
    @Shadow
    private float radius;
    @Final
    @Shadow
    @Nullable
    private Entity source;
    @Final
    @Shadow
    private Level level;
    @Shadow
    @Final
    private Explosion.BlockInteraction blockInteraction;

    @Shadow
    private static void addOrAppendStack(List<Pair<ItemStack, BlockPos>> list, ItemStack itemStack, BlockPos blockPos) {
    }

    @ModifyReceiver(method={"finalizeExplosion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onExplosionHit(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;Ljava/util/function/BiConsumer;)V")})
    private BlockState lychee_beforeOnExplosionHit(BlockState state, Level level, BlockPos blockPos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer, @Share(value="state") LocalRef<BlockState> stateRef, @Share(value="context") LocalRef<LycheeContext> contextRef, @Share(value="currentDrops") LocalRef<List<Pair<ItemStack, BlockPos>>> currentDropsRef) {
        if (level.isClientSide || RecipeTypes.BLOCK_EXPLODING.isEmpty() || !RecipeTypes.BLOCK_EXPLODING.has(state)) {
            contextRef.set(null);
            return state;
        }
        contextRef.set((Object)new LycheeContext());
        ((LycheeContext)((Object)contextRef.get())).put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = ((LycheeContext)((Object)contextRef.get())).get(LycheeContextKey.LOOT_PARAMS);
        lootParams.set(LootContextParams.ORIGIN, Vec3.atCenterOf((Vec3i)blockPos));
        lootParams.set(LootContextParams.BLOCK_STATE, state);
        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
        lootParams.set(LootContextParams.BLOCK_ENTITY, blockEntity);
        lootParams.set(LootContextParams.THIS_ENTITY, this.source);
        if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
            lootParams.set(LootContextParams.EXPLOSION_RADIUS, Float.valueOf(this.radius));
        }
        stateRef.set((Object)state);
        currentDropsRef.set((Object)Lists.newArrayList());
        return state;
    }

    @ModifyArg(method={"finalizeExplosion"}, index=3, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onExplosionHit(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;Ljava/util/function/BiConsumer;)V"))
    private BiConsumer<ItemStack, BlockPos> lychee_redirectDrops(BiConsumer<ItemStack, BlockPos> original, @Share(value="currentDrops") LocalRef<List<Pair<ItemStack, BlockPos>>> currentDropsRef) {
        return currentDropsRef.get() == null ? original : (itemStack, blockPos) -> ExplosionMixin.addOrAppendStack((List)currentDropsRef.get(), itemStack, blockPos);
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onExplosionHit(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;Ljava/util/function/BiConsumer;)V", shift=At.Shift.AFTER)})
    private void lychee_afterOnExplosionHit(boolean spawnParticles, CallbackInfo ci, @Local BlockPos blockPos, @Local List<Pair<ItemStack, BlockPos>> allDrops, @Share(value="state") LocalRef<BlockState> stateRef, @Share(value="context") LocalRef<LycheeContext> contextRef, @Share(value="currentDrops") LocalRef<List<Pair<ItemStack, BlockPos>>> currentDropsRef) {
        if (this.level.isClientSide) {
            return;
        }
        LycheeContext context = (LycheeContext)((Object)contextRef.get());
        if (context == null) {
            return;
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        lootParams.validate();
        ItemStackHolderCollection itemHolders = ItemStackHolderCollection.InWorld.of(new ItemEntity[0]);
        context.put(LycheeContextKey.ITEM, itemHolders);
        BlockState state = (BlockState)stateRef.get();
        RecipeHolder<BlockExplodingRecipe> recipe = RecipeTypes.BLOCK_EXPLODING.process(this.level, state, context);
        if (recipe == null) {
            if (currentDropsRef.get() != null) {
                allDrops.addAll((Collection)currentDropsRef.get());
            }
            return;
        }
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        if (!actionContext.avoidDefault && currentDropsRef.get() != null) {
            allDrops.addAll((Collection)currentDropsRef.get());
        }
        currentDropsRef.set(null);
        for (ItemStack stack : itemHolders.stacksNeedHandle) {
            ExplosionMixin.addOrAppendStack(allDrops, stack, blockPos);
        }
    }
}

