/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.action.Delay;
import snownee.lychee.action.Exit;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.contextual.Location;
import snownee.lychee.contextual.Not;
import snownee.lychee.mixin.particles.PointedDripstoneBlockAccess;
import snownee.lychee.mixin.predicates.LocationPredicate$BuilderAccess;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.particles.dripstone.DripstoneParticleService;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ChanceRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class DripstoneRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe,
ChanceRecipe {
    protected final BlockPredicate sourceBlock;
    protected final BlockPredicate targetBlock;
    private float chance = 1.0f;

    public DripstoneRecipe(LycheeRecipeCommonProperties commonProperties, BlockPredicate sourceBlock, BlockPredicate targetBlock) {
        super(commonProperties);
        this.sourceBlock = sourceBlock;
        this.targetBlock = targetBlock;
        this.onConstructed();
    }

    public static boolean invoke(BlockState blockState, ServerLevel level, BlockPos blockPos) {
        if (RecipeTypes.DRIPSTONE_DRIPPING.isEmpty()) {
            return false;
        }
        BlockPos tipPos = PointedDripstoneBlockAccess.callFindTip(blockState, (LevelAccessor)level, blockPos, 11, false);
        if (tipPos == null) {
            return false;
        }
        BlockPos targetPos = DripstoneRecipe.findTargetBelowStalactiteTip((Level)level, tipPos);
        if (targetPos == null) {
            return false;
        }
        BlockState sourceBlock = DripstoneParticleService.findBlockAboveStalactite((Level)level, blockPos, blockState);
        if (sourceBlock == null) {
            return false;
        }
        BlockState targetBlock = level.getBlockState(targetPos);
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        context.put(LycheeContextKey.DRIPSTONE_SOURCE, sourceBlock);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.DRIPSTONE_DRIPPING);
        lootParams.set(LootContextParams.BLOCK_STATE, targetBlock);
        Vec3 origin = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.99, (double)targetPos.getZ() + 0.5);
        lootParams.set(LootContextParams.ORIGIN, origin);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, targetPos);
        lootParams.validate();
        RecipeHolder recipe = RecipeTypes.DRIPSTONE_DRIPPING.process((Level)level, targetBlock, context);
        if (recipe == null) {
            return false;
        }
        level.levelEvent(1504, tipPos, 0);
        int i = tipPos.getY() - targetPos.getY();
        int j = 50 + i;
        LocationPredicate.Builder builder = new LocationPredicate.Builder();
        ((LocationPredicate$BuilderAccess)builder).setBlock(Optional.of(((DripstoneRecipe)recipe.value()).targetBlock));
        LocationCheck check = (LocationCheck)LocationCheck.checkLocation((LocationPredicate.Builder)builder).build();
        Exit exit = new Exit(new PostActionCommonProperties(new ContextualHolder(List.of(new Not(new Location(check)))), Optional.empty()));
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.jobs.offer(new Job(exit, 1));
        actionContext.jobs.offer(new Job(new Delay((float)j / 20.0f), 1));
        actionContext.run(context);
        return true;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        if (!BlockPredicateExtensions.matches(this.targetBlock, context)) {
            return false;
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        return BlockPredicateExtensions.unsafeMatches(level, this.sourceBlock, context.get(LycheeContextKey.DRIPSTONE_SOURCE), () -> level.getBlockEntity(lootParams.get(LycheeLootContextParams.BLOCK_POS)));
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public LycheeRecipeSerializer<DripstoneRecipe> getSerializer() {
        return RecipeSerializers.DRIPSTONE_DRIPPING;
    }

    @Override
    public LycheeRecipeType<DripstoneRecipe> getType() {
        return RecipeTypes.DRIPSTONE_DRIPPING;
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.targetBlock;
    }

    public BlockPredicate sourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public List<BlockPredicate> getBlockInputs() {
        return List.of(this.sourceBlock, this.targetBlock);
    }

    public static boolean safeTick(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!PointedDripstoneBlockAccess.callIsStalactiteStartPos(state, (LevelReader)serverLevel, blockPos)) {
            return false;
        }
        float f = randomSource.nextFloat();
        if (f > 0.17578125f && f > 0.05859375f) {
            return false;
        }
        return DripstoneRecipe.invoke(state, serverLevel, blockPos);
    }

    @Nullable
    private static BlockPos findTargetBelowStalactiteTip(Level level, BlockPos blockPos2) {
        Predicate<BlockState> predicate = blockState -> !blockState.isAir() && RecipeTypes.DRIPSTONE_DRIPPING.has((BlockState)blockState);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccess.callCanDripThrough((BlockGetter)level, blockPos, blockState);
        return PointedDripstoneBlockAccess.callFindBlockVertical((LevelAccessor)level, blockPos2, Direction.DOWN.getAxisDirection(), biPredicate, predicate, 11).orElse(null);
    }

    public static class Serializer
    implements LycheeRecipeSerializer<DripstoneRecipe> {
        public static final MapCodec<DripstoneRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.fieldOf("source_block").forGetter(DripstoneRecipe::sourceBlock), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.fieldOf("target_block").forGetter(DripstoneRecipe::blockPredicate)).apply((Applicative)instance, DripstoneRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DripstoneRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, DripstoneRecipe::sourceBlock, (StreamCodec)BlockPredicate.STREAM_CODEC, DripstoneRecipe::blockPredicate, DripstoneRecipe::new);

        @Override
        public MapCodec<DripstoneRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, DripstoneRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

