/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class ItemExplodingRecipe
extends LycheeRecipe<LycheeContext>
implements Comparable<ItemExplodingRecipe> {
    protected IngredientCollection ingredients;

    public static void invoke(ServerLevel level, double x, double y, double z, List<Entity> entityList, float radius) {
        Stream<ItemEntity> itemEntities = entityList.stream().filter(it -> it instanceof ItemEntity).map(ItemEntity.class::cast);
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.ITEM_EXPLODING);
        lootParams.set(LootContextParams.ORIGIN, new Vec3(x, y, z));
        lootParams.set(LootContextParams.EXPLOSION_RADIUS, Float.valueOf(radius));
        RecipeTypes.ITEM_EXPLODING.process(itemEntities, context);
    }

    public ItemExplodingRecipe(LycheeRecipeCommonProperties commonProperties, IngredientCollection ingredients) {
        super(commonProperties);
        this.ingredients = ingredients;
        this.onConstructed();
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        return ItemShapelessRecipeUtils.matches(context, this.ingredients);
    }

    @Override
    public LycheeRecipeSerializer<ItemExplodingRecipe> getSerializer() {
        return RecipeSerializers.ITEM_EXPLODING;
    }

    @Override
    public LycheeRecipeType<ItemExplodingRecipe> getType() {
        return RecipeTypes.ITEM_EXPLODING;
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    @Override
    public int compareTo(ItemExplodingRecipe that) {
        int i = Integer.compare(this.maxRepeats().isAny() ? 1 : 0, that.maxRepeats().isAny() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.isSpecial() ? 1 : 0, that.isSpecial() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), that.ingredients.size());
        return i;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ItemExplodingRecipe> {
        public static final MapCodec<ItemExplodingRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)IngredientCollection.CODEC.optionalFieldOf("item_in", (Object)IngredientCollection.EMPTY).forGetter(it -> it.ingredients)).apply((Applicative)instance, ItemExplodingRecipe::new)));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemExplodingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, IngredientCollection.STREAM_CODEC, it -> it.ingredients, ItemExplodingRecipe::new);

        @Override
        public MapCodec<ItemExplodingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ItemExplodingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

