/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.CraftingContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.mixin.recipes.crafting.ShapedRecipeAccess;
import snownee.lychee.mixin.recipes.crafting.ShapedRecipePatternAccess;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class ShapedCraftingRecipe
implements ILycheeRecipe<CraftingInput>,
CraftingRecipe {
    private static final Cache<CraftingInput, LycheeContext> CONTEXT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    protected final LycheeRecipeCommonProperties commonProperties;
    protected final ShapedRecipe shaped;
    protected final List<PostAction> assemblingActions;

    public ShapedCraftingRecipe(LycheeRecipeCommonProperties commonProperties, ShapedRecipe shaped, List<PostAction> assemblingActions) {
        this.commonProperties = commonProperties;
        this.assemblingActions = assemblingActions;
        this.shaped = shaped;
        this.onConstructed();
    }

    public ShapedCraftingRecipe(LycheeRecipeCommonProperties commonProperties, String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, List<PostAction> assemblingActions) {
        this(commonProperties, new ShapedRecipe(group, category, pattern, result, showNotification), assemblingActions);
    }

    @Override
    public LycheeRecipeCommonProperties commonProperties() {
        return this.commonProperties;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.getIngredients().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("result")) {
            return IntList.of((int)size);
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("key")) {
            String key = pointer.getString(1);
            if (key.length() != 1) {
                return IntList.of();
            }
            ShapedRecipePattern pattern = ((ShapedRecipeAccess)this.shaped).getPattern();
            Optional<ShapedRecipePattern.Data> dataOptional = ((ShapedRecipePatternAccess)pattern).data();
            if (dataOptional.isEmpty()) {
                return IntList.of();
            }
            ShapedRecipePattern.Data data = dataOptional.get();
            IntArrayList list = IntArrayList.of();
            char cp = key.charAt(0);
            Ingredient ingredient = (Ingredient)data.key().get(Character.valueOf(cp));
            for (int i = 0; i < this.getIngredients().size(); ++i) {
                if (ingredient != this.getIngredients().get(i)) continue;
                list.add(i);
            }
            return list;
        }
        return IntList.of((int)size);
    }

    @Override
    public boolean matches(CraftingInput input, Level level) {
        if (this.ghost()) {
            return false;
        }
        if (level.isClientSide) {
            return this.shaped.matches(input, level);
        }
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        context.put(LycheeContextKey.RECIPE, this);
        boolean mirror = false;
        boolean matched = false;
        ShapedRecipeAccess shapedRecipeAccess = (ShapedRecipeAccess)this.shaped;
        ShapedRecipePatternAccess pattern = (ShapedRecipePatternAccess)shapedRecipeAccess.getPattern();
        if (pattern.ingredientCount() != input.ingredientCount() || shapedRecipeAccess.getPattern().width() != input.width() || shapedRecipeAccess.getPattern().height() != input.height()) {
            return false;
        }
        if (this.getWidth() > 1 && pattern.callMatches(input, false)) {
            matched = true;
            mirror = true;
        } else if (pattern.callMatches(input, true)) {
            matched = true;
        }
        if (!matched) {
            return false;
        }
        CraftingContext craftingContext = new CraftingContext(context, input, mirror);
        context.put(LycheeContextKey.CRAFTING, craftingContext);
        boolean passed = this.conditions().test(this, context, 1) > 0;
        Pair pair = null;
        try {
            pair = (Pair)((Function)CraftingContext.CONTAINER_WORLD_LOCATOR.get(input.getClass())).apply(input);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        if (pair != null) {
            lootParams.set(LootContextParams.ORIGIN, (Vec3)pair.getFirst());
            lootParams.set(LootContextParams.THIS_ENTITY, (Entity)pair.getSecond());
        }
        CONTEXT_CACHE.put((Object)input, (Object)context);
        if (passed) {
            ItemStack result = this.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
            NonNullList<Ingredient> ingredients = this.getIngredients();
            ItemStack[] items = new ItemStack[ingredients.size() + 1];
            int k = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    items[k] = input.getItem(input.width() * i + (craftingContext.mirror() ? this.getWidth() - j - 1 : j));
                    if (!items[k].isEmpty()) {
                        items[k] = items[k].copy();
                        items[k].setCount(1);
                    }
                    ++k;
                }
            }
            items[ingredients.size()] = result;
            context.put(LycheeContextKey.ITEM, ItemStackHolderCollection.Inventory.of(context, items));
        }
        return passed;
    }

    @Override
    public ItemStack assemble(CraftingInput container, HolderLookup.Provider provider) {
        LycheeContext context = (LycheeContext)((Object)CONTEXT_CACHE.getIfPresent((Object)container));
        if (context == null) {
            return ItemStack.EMPTY;
        }
        CraftingContext craftingContext = context.getOrNull(LycheeContextKey.CRAFTING);
        if (craftingContext == null) {
            return ItemStack.EMPTY;
        }
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.reset();
        actionContext.jobs.addAll(this.assemblingActions.stream().map(it -> new Job((PostAction)it, 1)).toList());
        actionContext.run(context);
        return context.getItem(context.size() - 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList items = this.shaped.getRemainingItems((RecipeInput)container);
        LycheeContext context = (LycheeContext)((Object)CONTEXT_CACHE.getIfPresent((Object)container));
        if (context == null) {
            return items;
        }
        this.applyPostActions(context, 1);
        CraftingContext craftingContext = context.get(LycheeContextKey.CRAFTING);
        ItemStackHolderCollection itemStackHolders = context.get(LycheeContextKey.ITEM);
        int k = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                if (((ExtendedItemStackHolder)itemStackHolders.get(k)).getConsumption() == 0) {
                    items.set(container.width() * i + (craftingContext.mirror() ? this.getWidth() - j - 1 : j), (Object)context.getItem(k));
                }
                ++k;
            }
        }
        return items;
    }

    public RecipeSerializer<ShapedCraftingRecipe> getSerializer() {
        return RecipeSerializers.CRAFTING;
    }

    @Override
    public RecipeType<? extends CraftingRecipe> getType() {
        return RecipeType.CRAFTING;
    }

    public CraftingBookCategory category() {
        return this.shaped.category();
    }

    public String getGroup() {
        return this.shaped.getGroup();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.shaped.getResultItem(provider);
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.shaped.getIngredients();
    }

    public boolean showNotification() {
        return this.shaped.showNotification();
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return this.shaped.canCraftInDimensions(width, height);
    }

    public int getWidth() {
        return this.shaped.getWidth();
    }

    public int getHeight() {
        return this.shaped.getHeight();
    }

    public boolean isIncomplete() {
        return this.shaped.isIncomplete();
    }

    public boolean isSpecial() {
        return this.shaped.isSpecial();
    }

    public ItemStack getToastSymbol() {
        return this.shaped.getToastSymbol();
    }

    public List<PostAction> assemblingActions() {
        return this.assemblingActions;
    }

    public ShapedRecipe shaped() {
        return this.shaped;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ShapedCraftingRecipe> {
        public static final MapCodec<ShapedCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(ILycheeRecipe::commonProperties), (App)RecipeSerializer.SHAPED_RECIPE.codec().forGetter(ShapedCraftingRecipe::shaped), (App)PostAction.LIST_CODEC.optionalFieldOf("assembling", List.of()).forGetter(ShapedCraftingRecipe::assemblingActions)).apply((Applicative)instance, ShapedCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedCraftingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, ShapedCraftingRecipe::commonProperties, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)RecipeSerializer.SHAPED_RECIPE.codec().codec()), ShapedCraftingRecipe::shaped, PostAction.STREAM_LIST_CODEC, ShapedCraftingRecipe::assemblingActions, ShapedCraftingRecipe::new);

        @Override
        public MapCodec<ShapedCraftingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

