/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.input;

import java.util.function.Supplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public interface ItemStackHolder
extends Supplier<ItemStack> {
    public void set(ItemStack var1);

    default public ItemStack replace(ItemStack item) {
        ItemStack original = (ItemStack)this.get();
        if (!original.isEmpty()) {
            original.shrink(item.getCount());
        }
        this.set(item);
        return original;
    }

    default public ItemStack split(int amount) {
        return ((ItemStack)this.get()).split(amount);
    }

    public static class Entity
    implements ItemStackHolder {
        private final ItemEntity itemEntity;

        public Entity(ItemEntity itemEntity) {
            this.itemEntity = itemEntity;
        }

        @Override
        public ItemStack get() {
            return this.itemEntity.getItem();
        }

        @Override
        public void set(ItemStack stack) {
            this.itemEntity.setItem(stack);
        }

        public ItemEntity getEntity() {
            return this.itemEntity;
        }
    }

    public static class Direct
    implements ItemStackHolder {
        private ItemStack item;

        public Direct(ItemStack item) {
            this.item = item;
        }

        @Override
        public ItemStack get() {
            return this.item;
        }

        @Override
        public void set(ItemStack stack) {
            this.item = stack;
        }
    }
}

