/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.particles.dripstone;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.mixin.particles.PointedDripstoneBlockAccess;
import snownee.lychee.util.particles.dripstone.DripParticleHandler;

public class DripstoneParticleService {
    public static final Cache<Block, DripParticleHandler> particleHandlers = CacheBuilder.newBuilder().build();
    public static final ParticleType<BlockParticleOption> DRIPSTONE_DRIPPING = FabricParticleTypes.complex(BlockParticleOption::codec, BlockParticleOption::streamCodec);
    public static final ParticleType<BlockParticleOption> DRIPSTONE_FALLING = FabricParticleTypes.complex(BlockParticleOption::codec, BlockParticleOption::streamCodec);
    public static final ParticleType<BlockParticleOption> DRIPSTONE_SPLASH = FabricParticleTypes.complex(BlockParticleOption::codec, BlockParticleOption::streamCodec);

    public static boolean spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState) {
        BlockState sourceBlock = DripstoneParticleService.findBlockAboveStalactite(level, blockPos, blockState);
        if (sourceBlock == null || !RecipeTypes.DRIPSTONE_DRIPPING.hasSource(sourceBlock.getBlock())) {
            return false;
        }
        FluidState sourceFluid = sourceBlock.getFluidState();
        if (sourceFluid.is(FluidTags.LAVA) || sourceFluid.is(FluidTags.WATER)) {
            return false;
        }
        DripParticleHandler handler = DripstoneParticleService.getParticleHandler(level, sourceBlock);
        if (handler == null) {
            return false;
        }
        Vec3 vec3 = blockState.getOffset((BlockGetter)level, blockPos);
        double e = (double)blockPos.getX() + 0.5 + vec3.x;
        double f = (double)((float)(blockPos.getY() + 1) - 0.6875f) - 0.0625;
        double g = (double)blockPos.getZ() + 0.5 + vec3.z;
        handler.addParticle(level, blockPos, sourceBlock, e, f, g);
        return true;
    }

    public static DripParticleHandler getParticleHandler(Level level, BlockState sourceBlock) {
        Block block = sourceBlock.getBlock();
        try {
            return (DripParticleHandler)particleHandlers.get((Object)block, () -> {
                if (!Platform.isPhysicalClient()) {
                    return DripParticleHandler.SIMPLE_DUMMY;
                }
                BlockState defaultState = block.defaultBlockState();
                int color = defaultState.getMapColor((BlockGetter)level, (BlockPos)BlockPos.ZERO).col;
                return new DripParticleHandler.Simple(color, defaultState.getLightEmission() > 4);
            });
        }
        catch (ExecutionException e) {
            Lychee.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static BlockState findBlockAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return PointedDripstoneBlockAccess.callFindRootBlock(level, pos, state, 11).map(blockPos -> level.getBlockState(blockPos.above())).orElse(null);
    }
}

