/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;
import snownee.lychee.util.recipe.ValidItemCache;

public class ItemShapelessRecipeType<R extends ILycheeRecipe<LycheeContext>>
extends LycheeRecipeType<R> {
    private final ValidItemCache validItems = new ValidItemCache();

    public ItemShapelessRecipeType(String name, Class<R> clazz, @Nullable LootContextParamSet contextParamSet) {
        super(name, clazz, contextParamSet);
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        super.refreshCache();
        this.validItems.refreshCache(this.recipes);
    }

    public void process(Stream<ItemEntity> itemEntities, LycheeContext context) {
        if (this.isEmpty()) {
            return;
        }
        LinkedList list = itemEntities.filter($ -> this.validItems.contains($.getItem())).collect(Collectors.toCollection(LinkedList::new));
        context.put(LycheeContextKey.ITEM_SHAPELESS, new ItemShapelessContext(list, context));
        context.get(LycheeContextKey.LOOT_PARAMS).validate();
        ItemShapelessRecipeType.process(this, this.recipes, context, null);
    }

    public static <T extends ILycheeRecipe<LycheeContext>> void process(LycheeRecipeType<T> recipeType, Iterable<RecipeHolder<T>> recipes, LycheeContext context, @Nullable Predicate<RecipeHolder<T>> predicate) {
        boolean matched;
        boolean matchedAny = false;
        int loop = 0;
        HashSet excluded = Sets.newHashSet();
        Level level = context.level();
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        block2: do {
            matched = false;
            for (RecipeHolder<T> recipe : recipes) {
                if (((ILycheeRecipe)recipe.value()).getIngredients().isEmpty() && loop > 0 || excluded.contains(recipe)) continue;
                try {
                    Optional<RecipeHolder<T>> match = recipeType.tryMatch(recipe, level, context);
                    if (!match.isPresent()) continue;
                    if (predicate != null && !predicate.test(recipe)) {
                        excluded.add(recipe);
                        continue;
                    }
                    context.put(recipe);
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    Optional<RecipeMatcher<ItemStack>> matcher = itemShapelessContext.getMatcher();
                    if (matcher.map(it -> it.inputUsed.length > 0).orElse(false).booleanValue()) {
                        int[] inputUsed = matcher.get().inputUsed;
                        times = ((ILycheeRecipe)recipe.value()).getRandomRepeats(Integer.MAX_VALUE, context);
                        for (int i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            ItemStack stack = itemShapelessContext.filteredItems.get(i).getItem();
                            times = Math.min(times, stack.getCount() / inputUsed[i]);
                        }
                    }
                    ((ILycheeRecipe)match.get().value()).applyPostActions(context, times);
                    if (matcher.isPresent()) {
                        itemShapelessContext.totalItems = itemShapelessContext.totalItems - context.get(LycheeContextKey.ITEM).postApply(!actionContext.avoidDefault, times);
                    }
                    if (((ILycheeRecipe)recipe.value()).maxRepeats().isAny()) {
                        itemShapelessContext.filteredItems = null;
                        itemShapelessContext.setMatcher(null);
                        itemShapelessContext.itemEntities.removeIf(it -> it.getItem().isEmpty());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            itemShapelessContext.itemEntities.forEach(it -> it.setItem(it.getItem()));
        }
    }
}

