/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.registry;

import dev.ftb.mods.mecrh.entity.EggBomb;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mecrh");
    public static final Supplier<EntityType<EnderChicken>> ENDER_CHICKEN = ModEntityTypes.register("ender_chicken", ModEntityTypes::enderChicken);
    public static final Supplier<EntityType<EggBomb>> EGG_BOMB = ModEntityTypes.register("egg_bomb", ModEntityTypes::eggBomb);

    private static <E extends Entity> Supplier<EntityType<E>> register(String name, Supplier<EntityType.Builder<E>> sup) {
        return ENTITY_TYPES.register(name, () -> ((EntityType.Builder)sup.get()).build(name));
    }

    private static EntityType.Builder<EnderChicken> enderChicken() {
        return EntityType.Builder.of(EnderChicken::new, (MobCategory)MobCategory.MONSTER).sized(1.7f, 8.0f).eyeHeight(7.0f).clientTrackingRange(10);
    }

    private static EntityType.Builder<EggBomb> eggBomb() {
        return EntityType.Builder.of(EggBomb::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).eyeHeight(0.5f).clientTrackingRange(10);
    }
}

