/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HolystoneStarParticle
extends TextureSheetParticle {
    private final float initialScale;
    private final float rotationOffset;

    protected HolystoneStarParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 80 + this.random.nextInt(10);
        this.quadSize = this.initialScale = 0.15f + this.random.nextFloat() * 0.1f;
        this.rotationOffset = this.random.nextFloat() * ((float)Math.PI * 2);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.rCol = 1.0f;
        this.gCol = 0.95f + this.random.nextFloat() * 0.05f;
        this.bCol = 0.8f + this.random.nextFloat() * 0.2f;
        this.alpha = 1.0f;
        this.hasPhysics = false;
        this.pickSprite(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        float progress = (float)this.age / (float)this.lifetime;
        float sineWave = Mth.sin((float)(progress * (float)Math.PI * 4.0f + this.rotationOffset));
        this.quadSize = this.initialScale * (0.5f + 0.5f * (1.0f + sineWave * 0.3f));
        int fadeTime = 20;
        this.alpha = this.age < fadeTime ? (float)this.age / (float)fadeTime : (this.age > this.lifetime - fadeTime ? (float)(this.lifetime - this.age) / (float)fadeTime : 1.0f);
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HolystoneStarParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

