/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.block.ICarvable;
import com.leclowndu93150.chisel.block.BlockCarvablePane;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ChiselItemModelProvider
implements DataProvider {
    private final PackOutput output;

    public ChiselItemModelProvider(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList futures = new ArrayList();
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            for (Map.Entry<String, DeferredBlock<?>> entry : blockType.getBlocks().entrySet()) {
                JsonObject json;
                String variantName = entry.getKey();
                DeferredBlock<?> deferredBlock = entry.getValue();
                DeferredItem<BlockItem> item = blockType.getItem(variantName);
                if (item == null) continue;
                String registryPath = item.getId().getPath();
                Block block = (Block)deferredBlock.get();
                String texturePath = blockType.getName() + "/" + variantName;
                if (block instanceof ICarvable) {
                    ICarvable carvable = (ICarvable)block;
                    texturePath = carvable.getBlockType() + "/" + carvable.getVariation().getTextureName();
                }
                if (block instanceof BlockCarvablePane) {
                    BlockCarvablePane paneBlock = (BlockCarvablePane)block;
                    if (blockType == ChiselBlocks.IRONPANE) {
                        String mainTexture = "chisel:block/" + texturePath;
                        json = this.createGeneratedItemModel(mainTexture);
                    } else {
                        String sideTexture = "chisel:block/" + texturePath + "-side";
                        json = this.createGeneratedItemModel(sideTexture);
                    }
                } else {
                    json = this.createBlockItemModel("chisel:block/" + registryPath);
                }
                Path path = this.output.getOutputFolder().resolve("assets/chisel/models/item/" + registryPath + ".json");
                futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path));
            }
        }
        futures.add(this.saveToolItemModel(cache, "iron_chisel"));
        futures.add(this.saveToolItemModel(cache, "diamond_chisel"));
        futures.add(this.saveToolItemModel(cache, "hitech_chisel"));
        futures.add(this.saveToolItemModel(cache, "offset_tool"));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<?> saveToolItemModel(CachedOutput cache, String name) {
        JsonObject json = this.createGeneratedItemModel("chisel:item/" + name);
        Path path = this.output.getOutputFolder().resolve("assets/chisel/models/item/" + name + ".json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    private JsonObject createBlockItemModel(String parentModel) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", parentModel);
        return json;
    }

    private JsonObject createGeneratedItemModel(String texture) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", "minecraft:item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", texture);
        json.add("textures", (JsonElement)textures);
        return json;
    }

    public String getName() {
        return "Chisel Item Models";
    }
}

