/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.InventoryChiselSelection;
import com.leclowndu93150.chisel.inventory.SlotChiselInput;
import com.leclowndu93150.chisel.inventory.SlotChiselSelection;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ChiselMenu
extends AbstractContainerMenu {
    public static final int SELECTION_ROWS = 6;
    public static final int SELECTION_COLS = 10;
    public static final int SELECTION_SIZE = 60;
    public static final int SELECTION_LEFT = 62;
    public static final int SELECTION_TOP = 8;
    public static final int INPUT_X = 24;
    public static final int INPUT_Y = 24;
    public static final int PLAYER_INV_LEFT = 71;
    public static final int PLAYER_INV_TOP = 120;
    public static final int HOTBAR_TOP = 178;
    protected final InventoryChiselSelection inventoryChisel;
    protected final Inventory inventoryPlayer;
    protected final InteractionHand hand;
    protected final int chiselSlot;
    protected final ItemStack chisel;
    protected SlotChiselInput inputSlot;
    private ClickType currentClickType;
    public static Supplier<MenuType<ChiselMenu>> MENU_TYPE_SUPPLIER;

    public ChiselMenu(int containerId, Inventory playerInv, FriendlyByteBuf buf) {
        this(containerId, playerInv, buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public ChiselMenu(int containerId, Inventory playerInv, InteractionHand hand) {
        this(MENU_TYPE_SUPPLIER != null ? MENU_TYPE_SUPPLIER.get() : null, containerId, playerInv, hand, 60);
    }

    protected ChiselMenu(@Nullable MenuType<?> type, int containerId, Inventory playerInv, InteractionHand hand, int selectionSize) {
        super(type, containerId);
        ItemChisel itemChisel;
        ItemStack storedTarget;
        Item item;
        this.inventoryPlayer = playerInv;
        this.hand = hand;
        this.chiselSlot = hand == InteractionHand.MAIN_HAND ? playerInv.selected : playerInv.getContainerSize() - 1;
        this.chisel = playerInv.getItem(this.chiselSlot);
        this.inventoryChisel = new InventoryChiselSelection(this, selectionSize);
        this.addSelectionSlots(selectionSize);
        this.inputSlot = new SlotChiselInput(this, this.inventoryChisel, selectionSize, 24, 24);
        this.addSlot(this.inputSlot);
        this.addPlayerInventory(playerInv);
        if (!this.chisel.isEmpty() && (item = this.chisel.getItem()) instanceof ItemChisel && !(storedTarget = (itemChisel = (ItemChisel)item).getTarget(this.chisel)).isEmpty()) {
            this.inventoryChisel.setItem(selectionSize, storedTarget.copy());
        }
        this.inventoryChisel.updateItems();
    }

    protected void addSelectionSlots(int size) {
        int cols = this.getSelectionCols();
        for (int i = 0; i < size; ++i) {
            int x = this.getSelectionLeft() + i % cols * 18;
            int y = this.getSelectionTop() + i / cols * 18;
            this.addSlot(new SlotChiselSelection(this, this.inventoryChisel, i, x, y));
        }
    }

    protected void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, this.getPlayerInvLeft() + col * 18, this.getPlayerInvTop() + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, this.getPlayerInvLeft() + col * 18, this.getHotbarTop()));
        }
    }

    protected int getSelectionLeft() {
        return 62;
    }

    protected int getSelectionTop() {
        return 8;
    }

    protected int getSelectionCols() {
        return 10;
    }

    protected int getPlayerInvLeft() {
        return 71;
    }

    protected int getPlayerInvTop() {
        return 120;
    }

    protected int getHotbarTop() {
        return 178;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        int clickedPlayerSlot;
        if (clickTypeIn != ClickType.QUICK_CRAFT && slotId >= 0 && ((clickedPlayerSlot = slotId - this.inventoryChisel.getContainerSize() - 27) == this.chiselSlot || clickTypeIn == ClickType.SWAP && dragType == this.chiselSlot)) {
            return;
        }
        this.currentClickType = clickTypeIn;
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ClickType getCurrentClickType() {
        return this.currentClickType;
    }

    public void removed(Player player) {
        this.inventoryChisel.clearItems();
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        IChiselItem chiselItem;
        Item item;
        ItemStack held = this.inventoryPlayer.getItem(this.chiselSlot);
        return !held.isEmpty() && (item = held.getItem()) instanceof IChiselItem && (chiselItem = (IChiselItem)item).canOpenGui(player.level(), player, this.hand);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack quickMoveStack(Player player, int slotIdx) {
        int selectionSize;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIdx);
        if (slot == null || !slot.hasItem()) return itemstack;
        ItemStack slotStack = slot.getItem();
        itemstack = slotStack.copy();
        int inputSlotIndex = selectionSize = this.getSelectionSize();
        int playerInvStart = inputSlotIndex + 1;
        int playerInvEnd = playerInvStart + 36;
        if (slotIdx > selectionSize) {
            if (!CarvingHelper.canChisel(slotStack)) return ItemStack.EMPTY;
            if (!this.moveItemStackTo(slotStack, inputSlotIndex, inputSlotIndex + 1, false)) {
                return ItemStack.EMPTY;
            }
        } else if (slotIdx < selectionSize && !slotStack.isEmpty()) {
            SlotChiselSelection selectSlot = (SlotChiselSelection)slot;
            ItemStack check = SlotChiselSelection.craft(this, player, slotStack, true);
            if (check.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(check, playerInvStart, playerInvEnd, true)) {
                return ItemStack.EMPTY;
            }
            ItemStack result = SlotChiselSelection.craft(this, player, slotStack, false);
            if (!result.isEmpty()) {
                Block targetBlock = Blocks.AIR;
                Item item = slotStack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    targetBlock = blockItem.getBlock();
                }
                CarvingHelper.playChiselSound(player.level(), player, targetBlock);
            }
            this.inventoryChisel.setStackInSpecialSlot(this.inventoryChisel.getStackInSpecialSlot());
        } else if (!this.moveItemStackTo(slotStack, playerInvStart, playerInvEnd, true)) {
            return ItemStack.EMPTY;
        }
        boolean clearSlot = slotIdx >= selectionSize || this.inventoryChisel.getStackInSpecialSlot().isEmpty();
        slot.onQuickCraft(slotStack, itemstack);
        if (slotStack.isEmpty()) {
            if (clearSlot) {
                slot.set(ItemStack.EMPTY);
            }
        } else {
            slot.setChanged();
        }
        this.inventoryChisel.updateItems();
        if (slotStack.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        if (slotIdx >= selectionSize) {
            slot.onTake(player, slotStack);
        }
        if (slotStack.isEmpty()) {
            if (!clearSlot) return ItemStack.EMPTY;
            slot.set(ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (clearSlot) return slotStack;
        slot.set(itemstack);
        return slotStack;
    }

    public void onChiselSlotChanged() {
        Item item = this.chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setTarget(this.chisel, this.inventoryChisel.getStackInSpecialSlot());
        }
    }

    public void onChiselBroken() {
        if (!this.inventoryPlayer.player.level().isClientSide) {
            this.inventoryPlayer.player.drop(this.inventoryChisel.getStackInSpecialSlot(), false);
            this.inventoryChisel.setStackInSpecialSlot(ItemStack.EMPTY);
        }
    }

    public SlotChiselInput getInputSlot() {
        return this.inputSlot;
    }

    public InventoryChiselSelection getInventoryChisel() {
        return this.inventoryChisel;
    }

    public Inventory getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public int getSelectionSize() {
        return 60;
    }

    public ItemStack getChisel() {
        return this.chisel;
    }

    public int getChiselSlot() {
        return this.chiselSlot;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

