/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrotConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="solcarrot", bus=EventBusSubscriber.Bus.MOD)
public final class FoodItems {
    private static List<Item> foodsBeforeBlacklist;
    private static List<Item> foods;

    public static List<Item> getAllFoodsIgnoringBlacklist() {
        return new ArrayList<Item>(foodsBeforeBlacklist);
    }

    public static List<Item> getAllFoods() {
        return new ArrayList<Item>(foods);
    }

    public static void setUp() {
        foodsBeforeBlacklist = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().getFoodProperties(null) != null).sorted(Comparator.comparing(food -> I18n.get((String)(food.getDescriptionId() + ".name"), (Object[])new Object[0]))).collect(Collectors.toList());
        FoodItems.tryApplyBlacklist();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            return;
        }
    }

    @SubscribeEvent
    public static void onConfigUpdate(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            return;
        }
        FoodItems.tryApplyBlacklist();
    }

    private static void tryApplyBlacklist() {
        if (foodsBeforeBlacklist == null) {
            return;
        }
        if (!SOLCarrotConfig.SERVER_SPEC.isLoaded()) {
            return;
        }
        foods = foodsBeforeBlacklist.stream().filter(SOLCarrotConfig::isAllowed).collect(Collectors.toList());
    }
}

