/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.api.SOLCarrotAPI;
import com.cazsius.solcarrot.communication.FoodListMessage;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="solcarrot")
public final class CapabilityHandler {
    private static final ResourceLocation FOOD = SOLCarrot.resourceLocation("food");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLCarrotConfig.shouldResetOnDeath()) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        FoodList original = FoodList.get(originalPlayer);
        event.getEntity().setData(SOLCarrot.FOOD_ATTACHMENT, (Object)original);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    public static void syncFoodList(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)player;
            target.connection.send((CustomPacketPayload)new FoodListMessage(FoodList.get(player), (HolderLookup.Provider)player.registryAccess()));
        }
        MaxHealthHandler.updateFoodHPModifier(player);
    }

    @EventBusSubscriber(modid="solcarrot", bus=EventBusSubscriber.Bus.MOD)
    private static final class Setup {
        private Setup() {
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerEntity(SOLCarrotAPI.foodCapability, EntityType.PLAYER, (player, ctx) -> (FoodCapability)player.getData(SOLCarrot.FOOD_ATTACHMENT.get()));
        }
    }
}

