/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tfar.craftingstation.datagen.ModBlockTagsProvider;
import tfar.craftingstation.datagen.ModDataMapsProvider;
import tfar.craftingstation.datagen.ModLootTableProvider;

public class ModDatagen {
    public static void gather(GatherDataEvent e) {
        DataGenerator dataGenerator = e.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        CompletableFuture lookup = e.getLookupProvider();
        dataGenerator.addProvider(e.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookup, existingFileHelper));
        dataGenerator.addProvider(e.includeServer(), (DataProvider)new ModDataMapsProvider(packOutput, lookup));
        dataGenerator.addProvider(e.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput, lookup));
    }

    public static Stream<Block> getKnownBlocks() {
        return ModDatagen.getKnown(BuiltInRegistries.BLOCK);
    }

    public static Stream<Item> getKnownItems() {
        return ModDatagen.getKnown(BuiltInRegistries.ITEM);
    }

    public static Stream<EntityType<?>> getKnownEntityTypes() {
        return ModDatagen.getKnown(BuiltInRegistries.ENTITY_TYPE);
    }

    public static <V> Stream<V> getKnown(Registry<V> registry) {
        return registry.stream().filter(o -> registry.getKey(o).getNamespace().equals("craftingstation"));
    }
}

