/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.jei;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.platform.Services;
import tfar.craftingstation.util.SideContainerWrapper;

public class CraftingStationTransferHandler
implements IRecipeTransferInfo<CraftingStationMenu, RecipeHolder<CraftingRecipe>> {
    private static final Logger LOGGER = LogManager.getLogger((String)"CraftingStation/TransferHandler");

    public Class<? extends CraftingStationMenu> getContainerClass() {
        return CraftingStationMenu.class;
    }

    public Optional<MenuType<CraftingStationMenu>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public boolean canHandle(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        return true;
    }

    @NotNull
    public List<Slot> getRecipeSlots(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 1; i <= 9; ++i) {
            slots.add(container.getSlot(i));
        }
        return slots;
    }

    @NotNull
    public List<Slot> getInventorySlots(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        Minecraft mc = Minecraft.getInstance();
        EnumMap<Direction, SideContainerWrapper> wrapperCache = new EnumMap<Direction, SideContainerWrapper>(Direction.class);
        for (Slot slot : container.slots) {
            SideContainerWrapper wrapper;
            CraftingStationMenu.SideContainerSlot sideSlot;
            Direction direction;
            BlockEntity blockEntity;
            if (!(slot instanceof CraftingStationMenu.SideContainerSlot) || (blockEntity = container.blockEntityMap.get(direction = (sideSlot = (CraftingStationMenu.SideContainerSlot)slot).getDirection())) == null || (wrapper = wrapperCache.computeIfAbsent(direction, dir -> Services.PLATFORM.getWrapper(blockEntity))) == null) continue;
            int actualSlot = sideSlot.getActualSlot();
            int totalSlots = wrapper.$getSlotCount();
            if (actualSlot < 0 || actualSlot >= totalSlots || !wrapper.$valid(actualSlot)) continue;
            slots.add(slot);
        }
        int playerStart = container.getPlayerInventoryStartIndex();
        if (mc.player != null) {
            for (int i = playerStart; i < container.slots.size(); ++i) {
                Slot slot = container.getSlot(i);
                if (slot.container != mc.player.getInventory() || !slot.allowModification((Player)mc.player)) continue;
                slots.add(slot);
            }
        }
        return slots;
    }
}

