/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CodecUtils {
    public static final Codec<Block> BLOCK_CODEC = CodecUtils.registryCodec(BuiltInRegistries.BLOCK);
    public static final StreamCodec<ByteBuf, Block> BLOCK_STREAM_CODEC = CodecUtils.registryStreamCodec(BuiltInRegistries.BLOCK);
    public static final Codec<BlockState> BLOCKSTATE_CODEC = CodecUtils.blockStateCodec();
    public static final StreamCodec<ByteBuf, BlockState> BLOCKSTATE_STREAM_CODEC = CodecUtils.blockStateStreamCodec();
    public static final StreamCodec<ByteBuf, ChunkPos> CHUNK_POS_STREAM_CODEC = ByteBufCodecs.VAR_LONG.map(ChunkPos::new, ChunkPos::toLong);

    public static <T> Codec<T> registryCodec(Registry<T> registry) {
        return ResourceLocation.CODEC.xmap(arg_0 -> registry.get(arg_0), arg_0 -> registry.getKey(arg_0));
    }

    public static <T> StreamCodec<ByteBuf, T> registryStreamCodec(Registry<T> registry) {
        return ResourceLocation.STREAM_CODEC.map(arg_0 -> registry.get(arg_0), arg_0 -> registry.getKey(arg_0));
    }

    public static Codec<BlockState> blockStateCodec() {
        return TagParser.LENIENT_CODEC.xmap(state -> NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)state), NbtUtils::writeBlockState);
    }

    public static StreamCodec<ByteBuf, BlockState> blockStateStreamCodec() {
        return ByteBufCodecs.COMPOUND_TAG.map(state -> NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)state), NbtUtils::writeBlockState);
    }
}

