/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.Debug;
import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentState;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantmentMenuState {
    private final EnchantmentMenu menu;
    private final Int2ObjectOpenHashMap<List<EnchantmentInstance>> enchantments = new Int2ObjectOpenHashMap();
    private final Player player;
    private boolean freezeBroadcast = false;
    private ItemStack currentItem = ItemStack.EMPTY;
    private Boolean itemIsEnchantable = null;
    private EnchantmentState state = EnchantmentState.IDLE;

    public EnchantmentMenuState(EnchantmentMenu menu, Player player) {
        this.menu = menu;
        this.player = player;
    }

    public boolean isFreezeBroadcast() {
        return this.freezeBroadcast;
    }

    public void setFreezeBroadcast(boolean freezeBroadcast) {
        this.freezeBroadcast = freezeBroadcast;
    }

    public boolean matchesCurrentItem(ItemStack item) {
        return ItemStack.matches((ItemStack)this.currentItem, (ItemStack)item);
    }

    public void setCurrentItem(ItemStack currentItem) {
        this.currentItem = currentItem.copy();
        if (currentItem.isEmpty()) {
            this.itemIsEnchantable = null;
        }
    }

    public void clearEnchantments() {
        this.enchantments.clear();
    }

    public boolean storeItemIsEnchantable(boolean itemIsEnchantable) {
        this.itemIsEnchantable = itemIsEnchantable;
        return this.itemIsEnchantable;
    }

    public void setEnchantments(int index, List<EnchantmentInstance> enchantments) {
        if (Debug.ENCHANTMENT) {
            String s = enchantments.stream().map(ei -> {
                String string;
                Holder holder = ei.enchantment;
                if (holder instanceof Holder.Reference) {
                    Holder.Reference ref = (Holder.Reference)holder;
                    string = ref.key().location().toString();
                } else {
                    string = "<unknown>";
                }
                String key = string;
                int level = ei.level;
                return String.format("%s <Level: %d>", key, level);
            }).collect(Collectors.joining(", "));
            MoreJS.LOG.warn("Setting enchantments for index {} [{}] <{}>", (Object)index, (Object)s, (Object)this.player);
        }
        this.enchantments.put(index, new ArrayList<EnchantmentInstance>(enchantments));
    }

    public List<EnchantmentInstance> getEnchantments(int index) {
        return (List)this.enchantments.computeIfAbsent(index, $ -> new ArrayList());
    }

    public EnchantmentState getState() {
        return this.state;
    }

    public void setState(EnchantmentState storeEnchantments) {
        this.state = storeEnchantments;
    }

    public EnchantmentMenu getMenu() {
        return this.menu;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void prepareEvent(ItemStack item) {
        if (Debug.ENCHANTMENT) {
            MoreJS.LOG.warn("Prepare enchantment state for item <{}> with player <{}>", (Object)item, (Object)this.player);
        }
        this.setCurrentItem(item);
        this.clearEnchantments();
        this.setFreezeBroadcast(true);
        this.setState(EnchantmentState.STORE_ENCHANTMENTS);
    }

    public void reset(ItemStack item) {
        if (Debug.ENCHANTMENT) {
            MoreJS.LOG.warn("RESETTING enchantment state for item <{}> with player <{}>", (Object)item, (Object)this.player);
        }
        this.setCurrentItem(item);
        this.clearEnchantments();
        this.itemIsEnchantable = null;
        this.setState(EnchantmentState.IDLE);
    }

    public ItemStack getCurrentItem() {
        return this.currentItem;
    }
}

