/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.villager;

import com.almostreliable.morejs.features.villager.TradeMatcher;
import com.almostreliable.morejs.features.villager.TradeTypes;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

public class VillagerTradesMixin {

    @Mixin(value={VillagerTrades.TreasureMapForEmeralds.class})
    private static class TreasureMapForEmeraldsMixin
    implements TradeMatcher.Filterable {
        private TreasureMapForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, 64), new ItemStack((ItemLike)Items.FILLED_MAP), TradeTypes.TreasureMapForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EnchantBookForEmeralds.class})
    private static class EnchantBookForEmeraldsMixin
    implements TradeMatcher.Filterable {
        private EnchantBookForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, 64), new ItemStack((ItemLike)Items.ENCHANTED_BOOK), TradeTypes.EnchantBookForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.TippedArrowForItemsAndEmeralds.class})
    private static class TippedArrowForItemsAndEmeraldsMixin
    implements TradeMatcher.Filterable {
        @Shadow
        @Final
        private int emeraldCost;
        @Shadow
        @Final
        private Item fromItem;
        @Shadow
        @Final
        private int fromCount;
        @Shadow
        @Final
        private ItemStack toItem;
        @Shadow
        @Final
        private int toCount;

        private TippedArrowForItemsAndEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, this.emeraldCost), new ItemStack((ItemLike)this.fromItem, this.fromCount), new ItemStack((ItemLike)this.toItem.getItem(), this.toCount), TradeTypes.TippedArrowForItemsAndEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EmeraldsForVillagerTypeItem.class})
    private static class EmeraldsForVillagerTypeItemMixin
    implements TradeMatcher.Filterable {
        private EmeraldsForVillagerTypeItemMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.BARRIER), TradeTypes.EmeraldsForVillagerTypeItem);
        }
    }

    @Mixin(value={VillagerTrades.EnchantedItemForEmeralds.class})
    private static class EnchantedItemForEmeraldsMixin
    implements TradeMatcher.Filterable {
        @Shadow
        @Final
        private ItemStack itemStack;

        private EnchantedItemForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, 64), this.itemStack, TradeTypes.EnchantedItemForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.SuspiciousStewForEmerald.class})
    private static class SuspiciousStewForEmeraldMixin
    implements TradeMatcher.Filterable {
        private SuspiciousStewForEmeraldMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.SUSPICIOUS_STEW), TradeTypes.SuspiciousStewForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.ItemsAndEmeraldsToItems.class})
    private static class ItemsAndEmeraldsToItemsMixin
    implements TradeMatcher.Filterable {
        @Shadow
        @Final
        private int emeraldCost;
        @Shadow
        @Final
        private ItemCost fromItem;
        @Shadow
        @Final
        private ItemStack toItem;

        private ItemsAndEmeraldsToItemsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, this.emeraldCost), this.fromItem, this.toItem, TradeTypes.ItemsAndEmeraldsToItems);
        }
    }

    @Mixin(value={VillagerTrades.ItemsForEmeralds.class})
    private static class ItemsForEmeraldsMixin
    implements TradeMatcher.Filterable {
        @Shadow
        @Final
        private int emeraldCost;
        @Shadow
        @Final
        private ItemStack itemStack;

        private ItemsForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(new ItemStack((ItemLike)Items.EMERALD, this.emeraldCost), this.itemStack, TradeTypes.ItemsForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EmeraldForItems.class})
    private static class EmeraldForItemsMixin
    implements TradeMatcher.Filterable {
        @Shadow
        @Final
        private ItemCost itemStack;

        private EmeraldForItemsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeMatcher filter) {
            return filter.match(this.itemStack, new ItemStack((ItemLike)Items.EMERALD), TradeTypes.EmeraldForItems);
        }
    }
}

