/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.util;

import com.almostreliable.morejs.util.Utils;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceOrTag<T> {
    private final Either<ResourceKey<T>, TagKey<T>> either;

    private ResourceOrTag(Either<ResourceKey<T>, TagKey<T>> either) {
        this.either = either;
    }

    public static <E> ResourceOrTag<E> get(String s, ResourceKey<Registry<E>> registry) {
        if (s.startsWith("#")) {
            ResourceLocation rl = ResourceLocation.parse((String)s.substring(1));
            return new ResourceOrTag(Either.right((Object)TagKey.create(registry, (ResourceLocation)rl)));
        }
        ResourceLocation rl = ResourceLocation.parse((String)s);
        return new ResourceOrTag(Either.left((Object)ResourceKey.create(registry, (ResourceLocation)rl)));
    }

    public Optional<? extends HolderSet<T>> asHolderSet(Registry<T> registry) {
        return (Optional)this.either.map(id -> registry.getHolder(id).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), arg_0 -> registry.getTag(arg_0));
    }

    public Predicate<Holder<T>> asHolderPredicate() {
        return (Predicate)this.either.map(id -> holder -> holder.is(id), tag -> holder -> holder.is(tag));
    }

    public Component getName() {
        String name = (String)this.either.map(id -> id.location().toString(), tag -> "#" + tag.location().toString());
        return Component.literal((String)("Map for: " + Utils.format(name)));
    }
}

