/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.statuseffectbars.mixin.compat;

import com.leclowndu93150.statuseffectbars.config.StatusEffectBarsConfig;
import com.leclowndu93150.statuseffectbars.render.StatusEffectBarRenderer;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.EffectWidget;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractEffectRenderer.class}, remap=false)
public abstract class StylishEffectsCompatMixin
implements EffectWidget {
    @Shadow
    protected Object screen;

    @Shadow
    public abstract double getWidgetScale();

    @Shadow
    protected abstract Optional<Component> getEffectDuration(MobEffectInstance var1);

    @Shadow
    protected abstract ClientConfig.EffectWidgetConfig widgetConfig();

    @Shadow
    protected abstract ClientConfig.EffectRendererConfig rendererConfig();

    @Inject(method={"renderWidget"}, at={@At(value="TAIL")}, remap=false)
    private void statusEffectBars$addProgressBar(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance, CallbackInfo ci) {
        StatusEffectBarsConfig.LayoutConfig config;
        boolean isGui = this.screen instanceof Gui;
        StatusEffectBarsConfig.LayoutConfig layoutConfig = config = isGui ? StatusEffectBarsConfig.INSTANCE.hudLayout : StatusEffectBarsConfig.INSTANCE.inventoryLayout;
        if (!((Boolean)config.enabled.get()).booleanValue()) {
            return;
        }
        double scale = this.getWidgetScale();
        int actualX = (int)((double)posX * scale);
        int actualY = (int)((double)posY * scale);
        int actualWidth = (int)((double)this.getWidth() * scale);
        int actualHeight = (int)((double)this.getHeight() * scale);
        StatusEffectBarRenderer.render(guiGraphics, null, mobEffectInstance, actualX, actualY, actualWidth, actualHeight, config);
    }

    @Inject(method={"drawEffectText"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void statusEffectBars$renderSmallerDurationText(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance, CallbackInfo ci) {
        if (((Boolean)StatusEffectBarsConfig.INSTANCE.renderOldTimer.get()).booleanValue()) {
            return;
        }
        ci.cancel();
        if (((Boolean)StatusEffectBarsConfig.INSTANCE.renderCustomTimer.get()).booleanValue() && (this.widgetConfig().ambientDuration || !mobEffectInstance.isAmbient())) {
            this.getEffectDuration(mobEffectInstance).ifPresent(durationComponent -> {
                int textColor = 16775388;
                int alpha = (int)(this.rendererConfig().widgetAlpha * 255.0) << 24;
                FormattedCharSequence text = durationComponent.getVisualOrderText();
                float textScale = 0.6f;
                int offsetX = 4;
                int offsetY = 4;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(posX + offsetX), (float)(posY + offsetY), 0.0f);
                guiGraphics.pose().scale(textScale, textScale, 1.0f);
                guiGraphics.drawString(minecraft.font, text, -1, 0, alpha, false);
                guiGraphics.drawString(minecraft.font, text, 1, 0, alpha, false);
                guiGraphics.drawString(minecraft.font, text, 0, -1, alpha, false);
                guiGraphics.drawString(minecraft.font, text, 0, 1, alpha, false);
                guiGraphics.drawString(minecraft.font, text, 0, 0, alpha | textColor, false);
                guiGraphics.pose().popPose();
            });
        }
    }
}

