/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import it.hurts.shatterbyte.clavis.common.Clavis;
import it.hurts.shatterbyte.clavis.common.data.ValueModifier;
import it.hurts.shatterbyte.clavis.common.registry.ValueModifierRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;

public class ItemValues {
    public static final BiFunction<ItemStack, Double, Double> DEFAULT_FUNCTION = (itemStack, value) -> {
        double finalValue = value;
        for (ValueModifier modifier : ValueModifierRegistry.MODIFIERS.values()) {
            finalValue *= modifier.apply((ItemStack)itemStack);
        }
        return finalValue * (double)itemStack.getCount();
    };

    public static double getValue(ItemStack stack) {
        String itemId;
        Map<String, Double> overrides = Clavis.CONFIG.getValuableItems();
        if (overrides.containsKey(itemId = Objects.requireNonNull(stack.getItem().arch$registryName()).toString())) {
            return DEFAULT_FUNCTION.apply(stack, overrides.getOrDefault(itemId, Clavis.CONFIG.getDefaultBaseItemValue()));
        }
        AtomicReference<Double> value = new AtomicReference<Double>(0.0);
        stack.getTags().forEach(tagKey -> value.set((Double)value.get() + overrides.getOrDefault("#" + String.valueOf(tagKey.location()), 0.0)));
        if (value.get() <= 0.0) {
            return DEFAULT_FUNCTION.apply(stack, Clavis.CONFIG.getDefaultBaseItemValue());
        }
        return DEFAULT_FUNCTION.apply(stack, value.get());
    }
}

