/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;

public class BlockPosRangeArgument
implements ArgumentType<List<WorldCoordinates>> {
    public static BlockPosRangeArgument range() {
        return new BlockPosRangeArgument();
    }

    public List<WorldCoordinates> parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<WorldCoordinates> result = new ArrayList<WorldCoordinates>();
        WorldCoordinates wc1 = (WorldCoordinates)BlockPosArgument.blockPos().parse(reader);
        result.add(wc1);
        int afterFirst = reader.getCursor();
        if (reader.canRead() && reader.peek() == ' ') {
            try {
                WorldCoordinates wc2 = (WorldCoordinates)BlockPosArgument.blockPos().parse(reader);
                result.add(wc2);
            }
            catch (CommandSyntaxException ex) {
                reader.setCursor(afterFirst);
            }
        }
        return result;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String input = builder.getInput();
        StringReader reader = new StringReader(input);
        try {
            int start;
            BlockPosArgument.blockPos().parse(reader);
            int afterFirst = reader.getCursor();
            if (builder.getStart() <= afterFirst) {
                return BlockPosArgument.blockPos().listSuggestions(context, builder);
            }
            for (start = afterFirst; start < input.length() && Character.isWhitespace(input.charAt(start)); ++start) {
            }
            SuggestionsBuilder secondBuilder = new SuggestionsBuilder(input, start);
            return BlockPosArgument.blockPos().listSuggestions(context, secondBuilder);
        }
        catch (CommandSyntaxException ex) {
            return BlockPosArgument.blockPos().listSuggestions(context, builder);
        }
    }

    public static List<WorldCoordinates> getPositions(CommandContext<CommandSourceStack> ctx, String name) {
        return (List)ctx.getArgument(name, List.class);
    }

    public static List<BlockPos> resolve(CommandContext<CommandSourceStack> ctx, String name) {
        List<WorldCoordinates> coords = BlockPosRangeArgument.getPositions(ctx, name);
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (WorldCoordinates wc : coords) {
            result.add(wc.getBlockPos((CommandSourceStack)ctx.getSource()));
        }
        return result;
    }
}

