/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replicationaddon.block;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.block.shapes.MatterTankShapes;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.leclowndu93150.replicationaddon.block.tile.MatterVoidBlockEntity;
import com.leclowndu93150.replicationaddon.registry.ModRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterVoidBlock
extends RotatableBlock<MatterVoidBlockEntity>
implements INetworkDirectionalConnection {
    public MatterVoidBlock() {
        super("matter_void", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), MatterVoidBlockEntity.class);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, blockState) -> new MatterVoidBlockEntity((BasicTileBlock<MatterVoidBlockEntity>)this, (BlockEntityType)ModRegistry.MATTER_VOID_BE.get(), pos, blockState);
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return MatterTankShapes.SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return MatterTankShapes.SHAPE;
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        return direction == Direction.UP || direction == Direction.DOWN;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder builder) {
        MatterVoidBlockEntity tile;
        NonNullList stacks = NonNullList.create();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity tankTile = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tankTile instanceof MatterVoidBlockEntity && !(tile = (MatterVoidBlockEntity)tankTile).getTanks().get(0).getMatter().isEmpty()) {
            stack.set(ReplicationAttachments.TILE, (Object)NBTManager.getInstance().writeTileEntity((BlockEntity)tile, new CompoundTag()));
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack stack) {
        super.setPlacedBy(level, pos, p_49849_, p_49850_, stack);
        BlockEntity entity = level.getBlockEntity(pos);
        if (stack.has(ReplicationAttachments.TILE) && entity instanceof MatterVoidBlockEntity) {
            MatterVoidBlockEntity tile = (MatterVoidBlockEntity)entity;
            entity.loadCustomOnly((CompoundTag)stack.get(ReplicationAttachments.TILE), (HolderLookup.Provider)entity.getLevel().registryAccess());
            tile.markForUpdate();
        }
    }

    public void registerRecipe(RecipeOutput consumer) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"tooltip.replication_matter_overflow.matter_void.line1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.replication_matter_overflow.matter_void.line2").withStyle(ChatFormatting.GOLD));
    }
}

