/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block_network;

import com.buuz135.industrialforegoingsouls.config.IFSoulsMachines;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.NetworkManager;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoulNetwork
extends Network {
    public static ResourceLocation SOUL_NETWORK = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoingsouls", (String)"soul");
    private int soulAmount;

    public SoulNetwork(BlockPos originPos, String id, int soulAmount) {
        super(originPos, id);
        this.soulAmount = soulAmount;
    }

    public void update(Level level) {
        super.update(level);
    }

    public void onMergedWith(Network mainNetwork) {
        if (mainNetwork instanceof SoulNetwork) {
            SoulNetwork matterNetwork = (SoulNetwork)mainNetwork;
            this.addSouls(null, matterNetwork.soulAmount);
        }
    }

    public int addSouls(Level level, int soulAmount) {
        int oldAmount = this.soulAmount;
        this.soulAmount = Math.min(this.getMaxSouls(), soulAmount + oldAmount);
        if (level != null) {
            NetworkManager.get((Level)level).setDirty(true);
        }
        return this.soulAmount - oldAmount;
    }

    public int drainSouls(Level level, int soulAmount) {
        int oldAmount = this.soulAmount;
        this.soulAmount = Math.max(0, oldAmount - soulAmount);
        if (level != null) {
            NetworkManager.get((Level)level).setDirty(true);
        }
        return oldAmount - this.soulAmount;
    }

    public boolean useSoul(Level level) {
        if (this.soulAmount > 0) {
            --this.soulAmount;
            if (level != null) {
                NetworkManager.get((Level)level).setDirty(true);
            }
            return true;
        }
        return false;
    }

    public int getMaxSouls() {
        return this.graph.getElements().size() * IFSoulsMachines.SOUL_AMOUNT_PER_PIPE;
    }

    public int getSoulAmount() {
        return this.soulAmount;
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        CompoundTag nbt = super.writeToNbt(tag);
        nbt.putInt("soulAmount", this.soulAmount);
        return nbt;
    }

    public ResourceLocation getType() {
        return SOUL_NETWORK;
    }

    public static class Factory
    implements NetworkFactory {
        private static final Logger LOGGER = LogManager.getLogger(Factory.class);

        public Network create(BlockPos pos) {
            return new SoulNetwork(pos, NetworkFactory.randomString((Random)new Random(), (int)8), 0);
        }

        public Network create(CompoundTag tag) {
            SoulNetwork network = new SoulNetwork(BlockPos.of((long)tag.getLong("origin")), tag.getString("id"), tag.getInt("soulAmount"));
            LOGGER.debug("Deserialized matter network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
            return network;
        }
    }
}

