/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTankBlockEntity;
import cy.jdkdigital.productivemetalworks.util.RenderHelper;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;

public class FoundryTankBlockEntityRenderer
implements BlockEntityRenderer<FoundryTankBlockEntity> {
    public FoundryTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FoundryTankBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluidStack;
        if (blockEntity.getLevel() != null && !(fluidStack = blockEntity.getFluidHandler().getFluid()).isEmpty()) {
            poseStack.pushPose();
            VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            float fillProgress = (float)fluidStack.getAmount() / (float)blockEntity.getFluidHandler().getCapacity();
            float fluidY = RenderHelper.halfPixelFraction + fillProgress * 15.01f * RenderHelper.pixelFraction;
            int[] range = IntStream.range(0, 1).toArray();
            RenderHelper.renderFullFluidLayer(poseStack, vertexBuffer, 0.0f, fluidY, range, range, fluidStack, combinedLightIn, combinedOverlayIn, 1.0f, 0.01f);
            poseStack.popPose();
        }
    }
}

