/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemMeltingRecipe
implements Recipe<RecipeInput> {
    public final Ingredient item;
    public final List<FluidStack> result;
    public final int minTemperature;
    public final int maxTemperature;

    public ItemMeltingRecipe(Ingredient item, List<FluidStack> result, int minTemperature, int maxTemperature) {
        this.item = item;
        this.result = result;
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MetalworksRegistrator.ITEM_MELTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MetalworksRegistrator.ITEM_MELTING_TYPE.get();
    }

    public boolean matches(ItemStack input, int fuelTemperature) {
        return this.item.test(input) && this.minTemperature <= fuelTemperature;
    }

    public static class Serializer
    implements RecipeSerializer<ItemMeltingRecipe> {
        private static final MapCodec<ItemMeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.item), (App)FluidStack.CODEC.listOf().fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("minimum_temperature").forGetter(recipe -> recipe.minTemperature), (App)Codec.INT.fieldOf("maximum_temperature").orElse((Object)0).forGetter(recipe -> recipe.maxTemperature)).apply((Applicative)builder, ItemMeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemMeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ItemMeltingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemMeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ItemMeltingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new ItemMeltingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (List)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer), buffer.readInt(), buffer.readInt());
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, ItemMeltingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.item);
            FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.result);
            buffer.writeInt(recipe.minTemperature);
            buffer.writeInt(recipe.maxTemperature);
        }
    }
}

