/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.advancedexporter;

import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.advancedexporter.AdvancedExporterBlockEntity;
import edivad.extrastorage.setup.ESBlockEntities;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedExporterBlock
extends AbstractDirectionalCableBlock
implements EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation((String)"item", (String)"exporter.help");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private static final AbstractBlockEntityTicker<AdvancedExporterBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(ESBlockEntities.ADVANCED_EXPORTER);

    public AdvancedExporterBlock() {
        super(SHAPE_CACHE);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancedExporterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.EXPORTER_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.EXPORTER_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.EXPORTER_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.EXPORTER_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.EXPORTER_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.EXPORTER_DOWN;
        };
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, HELP);
    }
}

