/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.data;

import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.ExtraStorage;
import edivad.extrastorage.storage.AdvancedFluidStorageVariant;
import edivad.extrastorage.storage.AdvancedItemStorageVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ExtraStorageTags {

    public static class Items {
        public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final TagKey<Item> ITEM_STORAGE_BLOCKS = Items.tag("storage_blocks/items");
        public static final TagKey<Item> FLUID_STORAGE_BLOCKS = Items.tag("storage_blocks/fluids");
        public static final Map<AdvancedItemStorageVariant, TagKey<Item>> STORAGE_BLOCKS_ITEM = new HashMap<AdvancedItemStorageVariant, TagKey<Item>>();
        public static final Map<AdvancedFluidStorageVariant, TagKey<Item>> STORAGE_BLOCKS_FLUID = new HashMap<AdvancedFluidStorageVariant, TagKey<Item>>();
        public static final TagKey<Item> PARTS = Items.tag("parts");
        public static final TagKey<Item> ITEM_PARTS = Items.tag("parts/items");
        public static final TagKey<Item> FLUID_PARTS = Items.tag("parts/fluids");
        public static final Map<AdvancedItemStorageVariant, TagKey<Item>> PARTS_ITEM = new HashMap<AdvancedItemStorageVariant, TagKey<Item>>();
        public static final Map<AdvancedFluidStorageVariant, TagKey<Item>> PARTS_FLUID = new HashMap<AdvancedFluidStorageVariant, TagKey<Item>>();
        public static final TagKey<Item> DISKS = Items.tag("disks");
        public static final TagKey<Item> ITEM_DISKS = Items.tag("disks/items");
        public static final TagKey<Item> FLUID_DISKS = Items.tag("disks/fluids");
        public static final Map<AdvancedItemStorageVariant, TagKey<Item>> DISKS_ITEM = new HashMap<AdvancedItemStorageVariant, TagKey<Item>>();
        public static final Map<AdvancedFluidStorageVariant, TagKey<Item>> DISKS_FLUID = new HashMap<AdvancedFluidStorageVariant, TagKey<Item>>();

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)IdentifierUtil.createIdentifier((String)name));
        }

        static {
            for (AdvancedItemStorageVariant advancedItemStorageVariant : AdvancedItemStorageVariant.values()) {
                STORAGE_BLOCKS_ITEM.put(advancedItemStorageVariant, Items.tag("storage_blocks/items/" + advancedItemStorageVariant.getName()));
                PARTS_ITEM.put(advancedItemStorageVariant, Items.tag("parts/items/" + advancedItemStorageVariant.getName()));
                DISKS_ITEM.put(advancedItemStorageVariant, Items.tag("disks/items/" + advancedItemStorageVariant.getName()));
            }
            for (Enum enum_ : AdvancedFluidStorageVariant.values()) {
                STORAGE_BLOCKS_FLUID.put((AdvancedFluidStorageVariant)enum_, Items.tag("storage_blocks/fluids/" + ((AdvancedFluidStorageVariant)enum_).getName()));
                PARTS_FLUID.put((AdvancedFluidStorageVariant)enum_, Items.tag("parts/fluids/" + ((AdvancedFluidStorageVariant)enum_).getName()));
                DISKS_FLUID.put((AdvancedFluidStorageVariant)enum_, Items.tag("disks/fluids/" + ((AdvancedFluidStorageVariant)enum_).getName()));
            }
        }
    }

    public static class Blocks {
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.RSTag("storage_blocks");
        public static final TagKey<Block> CRAFTER = Blocks.tag("crafter");
        public static final TagKey<Block> ITEM_STORAGE_BLOCKS = Blocks.RSTag("storage_blocks/items");
        public static final TagKey<Block> FLUID_STORAGE_BLOCKS = Blocks.RSTag("storage_blocks/fluids");
        public static final Map<AdvancedItemStorageVariant, TagKey<Block>> STORAGE_BLOCKS_ITEM = new HashMap<AdvancedItemStorageVariant, TagKey<Block>>();
        public static final Map<AdvancedFluidStorageVariant, TagKey<Block>> STORAGE_BLOCKS_FLUID = new HashMap<AdvancedFluidStorageVariant, TagKey<Block>>();
        public static final TagKey<Block> CARRY_ON_BLACKLIST;
        public static final TagKey<Block> MEKANISM_BLACKLIST;

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)ExtraStorage.rl(name));
        }

        private static TagKey<Block> RSTag(String name) {
            return BlockTags.create((ResourceLocation)IdentifierUtil.createIdentifier((String)name));
        }

        private static TagKey<Block> carryOnTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"carryon", (String)name));
        }

        private static TagKey<Block> mekanismTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)name));
        }

        private static TagKey<Block> packingTapeTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"packingtape", (String)name));
        }

        static {
            for (AdvancedItemStorageVariant advancedItemStorageVariant : AdvancedItemStorageVariant.values()) {
                STORAGE_BLOCKS_ITEM.put(advancedItemStorageVariant, Blocks.RSTag("storage_blocks/items/" + advancedItemStorageVariant.getName()));
            }
            for (Enum enum_ : AdvancedFluidStorageVariant.values()) {
                STORAGE_BLOCKS_FLUID.put((AdvancedFluidStorageVariant)enum_, Blocks.RSTag("storage_blocks/fluids/" + ((AdvancedFluidStorageVariant)enum_).getName()));
            }
            CARRY_ON_BLACKLIST = Blocks.carryOnTag("block_blacklist");
            MEKANISM_BLACKLIST = Blocks.mekanismTag("cardboard_blacklist");
        }
    }
}

