/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.storage.advancedstorageblock;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import edivad.extrastorage.setup.ESBlockEntities;
import edivad.extrastorage.setup.ESContainer;
import edivad.extrastorage.storage.AdvancedFluidStorageVariant;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class AdvancedFluidStorageBlockProvider
implements StorageBlockProvider {
    private final AdvancedFluidStorageVariant variant;
    private final Component displayName;

    public AdvancedFluidStorageBlockProvider(AdvancedFluidStorageVariant variant) {
        this.variant = variant;
        this.displayName = Component.translatable((String)"block.%s.block_%s_fluid".formatted("extrastorage", variant.getName()));
    }

    public SerializableStorage createStorage(Runnable runnable) {
        return StorageTypes.FLUID.create(this.variant.getCapacity(), runnable);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return this.variant.getEnergyUsage();
    }

    public ResourceFactory getResourceFactory() {
        return RefinedStorageApi.INSTANCE.getFluidResourceFactory();
    }

    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)ESBlockEntities.FLUID_STORAGE.get((Object)this.variant).get();
    }

    public MenuType<?> getMenuType() {
        return (MenuType)ESContainer.FLUID_STORAGE.get((Object)this.variant).get();
    }
}

