/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.capability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ActiveAbilityData
implements INBTSerializable<CompoundTag> {
    private AffinityPerkType activeAbilityType = null;
    private boolean isDirty = false;

    public AffinityPerkType getActiveAbilityType() {
        return this.activeAbilityType;
    }

    public void setActiveAbilityType(AffinityPerkType abilityType) {
        if (this.activeAbilityType != abilityType) {
            this.activeAbilityType = abilityType;
            this.markDirty();
        }
    }

    public void clearActiveAbility() {
        if (this.activeAbilityType != null) {
            this.activeAbilityType = null;
            this.markDirty();
        }
    }

    public boolean hasActiveAbility() {
        return this.activeAbilityType != null;
    }

    public boolean isActiveAbility(AffinityPerkType abilityType) {
        return this.activeAbilityType == abilityType;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.activeAbilityType != null) {
            tag.putString("activeAbilityType", this.activeAbilityType.name());
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        if (tag.contains("activeAbilityType")) {
            String abilityTypeName = tag.getString("activeAbilityType");
            try {
                this.activeAbilityType = AffinityPerkType.valueOf(abilityTypeName);
            }
            catch (IllegalArgumentException e) {
                ArsAffinity.LOGGER.warn("Unknown active ability type: {}", (Object)abilityTypeName);
                this.activeAbilityType = null;
            }
        } else {
            this.activeAbilityType = null;
        }
    }
}

