/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.particles;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.particles.SpiralParticle;
import com.github.ars_affinity.client.particles.SpiralParticleTypeData;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.resources.ResourceLocation;

public class SpiralParticleWrapper
implements ParticleProvider<SpiralParticleTypeData> {
    private final SpriteSet defaultSpriteSet;
    private final SpriteSet bubbleSpriteSet;
    private final SpriteSet flameSpriteSet;

    public SpiralParticleWrapper(SpriteSet defaultSpriteSet) {
        this.defaultSpriteSet = defaultSpriteSet;
        SpriteSet bubble = null;
        SpriteSet flame = null;
        try {
            ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
            Field spriteSetsField = particleEngine.getClass().getDeclaredField("spriteSets");
            spriteSetsField.setAccessible(true);
            Map spriteSets = (Map)spriteSetsField.get(particleEngine);
            bubble = (SpriteSet)spriteSets.get(ResourceLocation.withDefaultNamespace((String)"bubble"));
            flame = (SpriteSet)spriteSets.get(ResourceLocation.withDefaultNamespace((String)"flame"));
            ArsAffinity.LOGGER.debug("Successfully loaded sprite sets - bubble: {}, flame: {}", (Object)(bubble != null ? 1 : 0), (Object)(flame != null ? 1 : 0));
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.warn("Failed to load sprite sets via reflection: {}", (Object)e.getMessage());
        }
        this.bubbleSpriteSet = bubble;
        this.flameSpriteSet = flame;
    }

    public Particle createParticle(SpiralParticleTypeData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ArsAffinity.LOGGER.debug("SpiralParticleWrapper.createParticle called at ({}, {}, {}) with color ({}, {}, {}), scale={}, lifetime={}, spriteType={}", (Object)x, (Object)y, (Object)z, (Object)Float.valueOf(data.color.getRed()), (Object)Float.valueOf(data.color.getGreen()), (Object)Float.valueOf(data.color.getBlue()), (Object)Float.valueOf(data.size), (Object)data.age, (Object)data.spriteType);
        SpriteSet spriteSet = this.getSpriteSetForType(data.spriteType);
        return new SpiralParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, data.color.getRed(), data.color.getGreen(), data.color.getBlue(), data.size, data.age, spriteSet, data.playerId, data.schoolId);
    }

    private SpriteSet getSpriteSetForType(String spriteType) {
        return switch (spriteType) {
            case "bubble" -> {
                if (this.bubbleSpriteSet != null) {
                    yield this.bubbleSpriteSet;
                }
                yield this.defaultSpriteSet;
            }
            case "flame" -> {
                if (this.flameSpriteSet != null) {
                    yield this.flameSpriteSet;
                }
                yield this.defaultSpriteSet;
            }
            default -> this.defaultSpriteSet;
        };
    }
}

