/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.command;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.capability.PlayerAffinityDataProvider;
import com.github.ars_affinity.config.ArsAffinityConfig;
import com.github.ars_affinity.event.SchoolAffinityPointAllocatedEvent;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.github.ars_affinity.school.SchoolRelationshipHelper;
import com.github.ars_affinity.util.ChatMessageHelper;
import com.github.ars_affinity.util.GlyphBlacklistHelper;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ArsAffinityCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-affinity").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"school", (ArgumentType)StringArgumentType.word()).suggests(ArsAffinityCommands.getSchoolSuggestions()).then(Commands.argument((String)"percentage", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(ArsAffinityCommands::setAffinity))))).then(Commands.literal((String)"get").then(Commands.argument((String)"school", (ArgumentType)StringArgumentType.word()).suggests(ArsAffinityCommands.getSchoolSuggestions()).executes(ArsAffinityCommands::getAffinity)))).then(Commands.literal((String)"reset").then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests(ArsAffinityCommands.getResetSuggestions()).executes(ArsAffinityCommands::resetAffinity)))).then(Commands.literal((String)"list").executes(ArsAffinityCommands::listAllAffinities))).then(Commands.literal((String)"list-perks").executes(ArsAffinityCommands::listPerks))).then(Commands.literal((String)"blacklist").executes(ArsAffinityCommands::showGlyphBlacklist)));
    }

    private static int setAffinity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String schoolName = StringArgumentType.getString(context, (String)"school");
        float percentage = FloatArgumentType.getFloat(context, (String)"percentage");
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)player);
        if (data == null) {
            source.sendFailure((Component)Component.literal((String)"Failed to get affinity data for player"));
            return 0;
        }
        SpellSchool school = ArsAffinityCommands.parseSpellSchool(schoolName);
        if (school == null) {
            source.sendFailure((Component)Component.literal((String)("Unknown school: " + schoolName)));
            return 0;
        }
        float currentPercentage = data.getSchoolPercentage(school);
        float percentageIncrease = percentage - currentPercentage;
        if (percentageIncrease > 0.0f) {
            pointsAwarded = data.addSchoolProgress(school, percentageIncrease);
            if (pointsAwarded > 0) {
                event = new SchoolAffinityPointAllocatedEvent((Player)player, school, pointsAwarded, data.getSchoolPoints(school));
                NeoForge.EVENT_BUS.post((Event)event);
            }
        } else if (percentageIncrease < 0.0f) {
            data.resetSchoolPercentage(school);
            data.setSchoolPoints(school, 0);
            pointsAwarded = data.addSchoolProgress(school, percentage);
            if (pointsAwarded > 0) {
                event = new SchoolAffinityPointAllocatedEvent((Player)player, school, pointsAwarded, data.getSchoolPoints(school));
                NeoForge.EVENT_BUS.post((Event)event);
            }
        }
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
        String displayName = ArsAffinityCommands.getSchoolDisplayName(school);
        source.sendSuccess(() -> Component.literal((String)String.format("Set %s affinity to %.1f%% (%d/%d points)", displayName, Float.valueOf(percentage), data.getSchoolPoints(school), maxPoints)), true);
        ArsAffinity.LOGGER.debug("Player {} set {} affinity to {}% ({} points)", (Object)player.getName().getString(), (Object)displayName, (Object)Float.valueOf(percentage), (Object)data.getSchoolPoints(school));
        PlayerAffinityDataHelper.savePlayerData((Player)player);
        PlayerAffinityDataProvider.syncToClient((Player)player);
        return 1;
    }

    private static int getAffinity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String schoolName = StringArgumentType.getString(context, (String)"school");
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)player);
        if (data == null) {
            source.sendFailure((Component)Component.literal((String)"Failed to get affinity data for player"));
            return 0;
        }
        SpellSchool school = ArsAffinityCommands.parseSpellSchool(schoolName);
        if (school == null) {
            source.sendFailure((Component)Component.literal((String)("Unknown school: " + schoolName)));
            return 0;
        }
        int currentPoints = data.getSchoolPoints(school);
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
        float percentage = data.getSchoolAffinityPercentage(school) * 100.0f;
        String displayName = ArsAffinityCommands.getSchoolDisplayName(school);
        source.sendSuccess(() -> Component.literal((String)String.format("%s: %d/%d points (%.1f%%)", displayName, currentPoints, maxPoints, Float.valueOf(percentage))), false);
        return 1;
    }

    private static int resetAffinity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String target = StringArgumentType.getString(context, (String)"target");
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)player);
        if (data == null) {
            ChatMessageHelper.sendAllSchoolsResetFailureMessage(player, "Failed to get affinity data for player");
            return 0;
        }
        if (target.equalsIgnoreCase("all")) {
            int totalPointsReset = 0;
            for (SpellSchool school : SchoolRelationshipHelper.ALL_SCHOOLS) {
                int currentPoints = data.getSchoolPoints(school);
                totalPointsReset += currentPoints;
            }
            data.respecAll();
            for (SpellSchool school : SchoolRelationshipHelper.ALL_SCHOOLS) {
                data.setSchoolPoints(school, 0);
                data.resetSchoolPercentage(school);
            }
            ChatMessageHelper.sendAllSchoolsResetMessage(player, totalPointsReset);
            PlayerAffinityDataHelper.savePlayerData((Player)player);
            PlayerAffinityDataProvider.syncToClient((Player)player);
            return 1;
        }
        SpellSchool school = ArsAffinityCommands.parseSpellSchool(target);
        if (school == null) {
            source.sendFailure((Component)Component.literal((String)("Unknown school: " + target + ". Use 'all' to reset all schools or a valid school name.")));
            return 0;
        }
        int currentPoints = data.getSchoolPoints(school);
        data.respecSchool(school);
        data.setSchoolPoints(school, 0);
        data.resetSchoolPercentage(school);
        ChatMessageHelper.sendSchoolResetMessage(player, school, currentPoints);
        PlayerAffinityDataHelper.savePlayerData((Player)player);
        PlayerAffinityDataProvider.syncToClient((Player)player);
        return 1;
    }

    private static int listAllAffinities(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)player);
        if (data == null) {
            source.sendFailure((Component)Component.literal((String)"Failed to get affinity data for player"));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Current Affinities:"), false);
        for (SpellSchool school : SchoolRelationshipHelper.ALL_SCHOOLS) {
            int currentPoints = data.getSchoolPoints(school);
            int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
            float progressPercentage = data.getSchoolPercentage(school);
            source.sendSuccess(() -> Component.literal((String)String.format("  %s: %d/%d points (%.1f%% progress)", school.getId(), currentPoints, maxPoints, Float.valueOf(progressPercentage))), false);
        }
        return 1;
    }

    private static int showGlyphBlacklist(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            List blacklist = (List)ArsAffinityConfig.GLYPH_BLACKLIST.get();
            if (blacklist == null || blacklist.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"Glyph blacklist is empty - no glyphs are blacklisted"), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)("Glyph blacklist contains " + blacklist.size() + " entries:")), false);
                for (String glyphId : blacklist) {
                    source.sendSuccess(() -> Component.literal((String)("  - " + glyphId)), false);
                }
            }
            GlyphBlacklistHelper.logBlacklistConfiguration();
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Error reading glyph blacklist configuration: " + e.getMessage())));
            ArsAffinity.LOGGER.error("Error reading glyph blacklist configuration: {}", (Object)e.getMessage());
            return 0;
        }
        return 1;
    }

    private static int listPerks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)player);
        if (data == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Failed to get affinity data"));
            return 0;
        }
        Set<PerkAllocation> activePerkAllocations = data.getAllAllocatedPerks();
        if (activePerkAllocations.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No active perks"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Active perks:"), false);
        for (PerkAllocation allocation : activePerkAllocations) {
            AffinityPerkType perkType = allocation.getPerkType();
            SpellSchool school = allocation.getSchool();
            int tier = allocation.getTier();
            String perkName = perkType.name().replace("_", " ").toLowerCase();
            String schoolName = school.getId().toString().replace("ars_nouveau:", "").replace("_", " ").toLowerCase();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("  - " + perkName + " (" + schoolName + " Tier " + tier + ")")), false);
        }
        return 1;
    }

    private static SuggestionProvider<CommandSourceStack> getSchoolSuggestions() {
        return (context, builder) -> {
            String[] schoolNames = (String[])Arrays.stream(SchoolRelationshipHelper.ALL_SCHOOLS).map(school -> ArsAffinityCommands.getSchoolDisplayName(school)).toArray(String[]::new);
            return SharedSuggestionProvider.suggest((String[])schoolNames, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSourceStack> getResetSuggestions() {
        return (context, builder) -> {
            builder.suggest("all");
            String[] schoolNames = (String[])Arrays.stream(SchoolRelationshipHelper.ALL_SCHOOLS).map(school -> ArsAffinityCommands.getSchoolDisplayName(school)).toArray(String[]::new);
            return SharedSuggestionProvider.suggest((String[])schoolNames, (SuggestionsBuilder)builder);
        };
    }

    private static SpellSchool parseSpellSchool(String schoolName) {
        return switch (schoolName.toLowerCase()) {
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            case "abjuration" -> SpellSchools.ABJURATION;
            case "conjuration" -> SpellSchools.CONJURATION;
            case "necromancy", "anima" -> SpellSchools.NECROMANCY;
            case "manipulation" -> SpellSchools.MANIPULATION;
            default -> null;
        };
    }

    private static String getSchoolDisplayName(SpellSchool school) {
        if (school == SpellSchools.NECROMANCY) {
            return "anima";
        }
        return school.getId().toString().replaceAll("_", " ");
    }
}

