/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.helper.MathUtils;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SwapAbilityHelper {
    private static final double MAX_DISTANCE = 100.0;

    public static void executeAbility(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        double requiredMana;
        ArsAffinity.LOGGER.debug("SWAP ABILITY: Starting execution for player {} with perk: manaCost={}, cooldown={}", (Object)player.getName().getString(), (Object)Float.valueOf(perk.manaCost), (Object)perk.cooldown);
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap == null) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: Player {} has no mana capability", (Object)player.getName().getString());
            return;
        }
        double currentMana = manaCap.getCurrentMana();
        if (currentMana < (requiredMana = (double)perk.manaCost)) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: Player {} doesn't have enough mana. Required: {}, Current: {}", (Object)player.getName().getString(), (Object)requiredMana, (Object)currentMana);
            return;
        }
        if (SwapAbilityHelper.isPlayerOnCooldown(player)) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: Player {} is on cooldown", (Object)player.getName().getString());
            return;
        }
        ArsAffinity.LOGGER.debug("SWAP ABILITY: Attempting to find entity with range {}", (Object)100.0);
        EntityHitResult entityHitResult = MathUtils.getLookedAtEntity((Entity)player, 100.0);
        ArsAffinity.LOGGER.debug("SWAP ABILITY: getLookedAtEntity returned: {}", (Object)entityHitResult);
        if (entityHitResult == null) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: No valid target found for player {}", (Object)player.getName().getString());
            return;
        }
        Entity entity = entityHitResult.getEntity();
        if (!(entity instanceof LivingEntity)) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: Target is not a living entity: {}", (Object)entityHitResult.getEntity().getName().getString());
            return;
        }
        LivingEntity targetEntity = (LivingEntity)entity;
        if (targetEntity == player) {
            ArsAffinity.LOGGER.debug("SWAP ABILITY: Player {} cannot swap with themselves", (Object)player.getName().getString());
            return;
        }
        SwapAbilityHelper.applyCooldown(player, perk.cooldown);
        SwapAbilityHelper.performSwap(player, targetEntity);
        SwapAbilityHelper.consumeMana(player, perk);
        ArsAffinity.LOGGER.debug("SWAP ABILITY: Successfully swapped positions between player {} and entity {}", (Object)player.getName().getString(), (Object)targetEntity.getName().getString());
    }

    private static void performSwap(ServerPlayer player, LivingEntity target) {
        Vec3 playerPos = player.position();
        Vec3 targetPos = target.position();
        float playerYRot = player.getYRot();
        float playerXRot = player.getXRot();
        float targetYRot = target.getYRot();
        float targetXRot = target.getXRot();
        SwapAbilityHelper.spawnEnderParticles(player.level(), playerPos);
        SwapAbilityHelper.spawnEnderParticles(player.level(), targetPos);
        player.teleportTo(targetPos.x, targetPos.y, targetPos.z);
        target.teleportTo(playerPos.x, playerPos.y, playerPos.z);
        player.setYRot(targetYRot);
        player.setXRot(targetXRot);
        target.setYRot(playerYRot);
        target.setXRot(playerXRot);
        player.level().playSound(null, playerPos.x, playerPos.y, playerPos.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.level().playSound(null, targetPos.x, targetPos.y, targetPos.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        SwapAbilityHelper.spawnEnderParticles(player.level(), player.position());
        SwapAbilityHelper.spawnEnderParticles(player.level(), target.position());
    }

    private static void spawnEnderParticles(Level level, Vec3 pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 20; ++i) {
                double x = pos.x + (level.random.nextDouble() - 0.5) * 0.5;
                double y = pos.y + level.random.nextDouble() * 1.0;
                double z = pos.z + (level.random.nextDouble() - 0.5) * 0.5;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void consumeMana(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap != null) {
            int manaToConsume = (int)perk.manaCost;
            manaCap.removeMana((double)manaToConsume);
        }
    }

    private static boolean isPlayerOnCooldown(ServerPlayer player) {
        return player.hasEffect(ModPotions.SWAP_COOLDOWN_EFFECT);
    }

    private static void applyCooldown(ServerPlayer player, int cooldownTicks) {
        player.addEffect(new MobEffectInstance(ModPotions.SWAP_COOLDOWN_EFFECT, cooldownTicks, 0, false, true, true));
    }
}

