/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.event.SchoolAffinityPointAllocatedEvent;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class AffinityAdvancementEvents {
    private static final ResourceLocation INITIATION = ArsAffinity.prefix("affinity_initiate");
    private static final Map<SpellSchool, ResourceLocation> COMPLETION_ADVANCEMENTS = Map.of(SpellSchools.ELEMENTAL_FIRE, ArsAffinity.prefix("affinity_fire_mastery"), SpellSchools.ELEMENTAL_WATER, ArsAffinity.prefix("affinity_water_mastery"), SpellSchools.ELEMENTAL_EARTH, ArsAffinity.prefix("affinity_earth_mastery"), SpellSchools.ELEMENTAL_AIR, ArsAffinity.prefix("affinity_air_mastery"), SpellSchools.ABJURATION, ArsAffinity.prefix("affinity_abjuration_mastery"), SpellSchools.CONJURATION, ArsAffinity.prefix("affinity_conjuration_mastery"), SpellSchools.NECROMANCY, ArsAffinity.prefix("affinity_necromancy_mastery"), SpellSchools.MANIPULATION, ArsAffinity.prefix("affinity_manipulation_mastery"));

    @SubscribeEvent
    public static void onPointAllocated(SchoolAffinityPointAllocatedEvent event) {
        SpellSchool school;
        ResourceLocation advancementId;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            ArsAffinity.LOGGER.debug("Advancement event skipped: player is not ServerPlayer");
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData((Player)serverPlayer);
        if (data == null) {
            ArsAffinity.LOGGER.warn("Advancement event skipped: PlayerAffinityData is null");
            return;
        }
        if (data.getTotalPointsAcrossAllSchools() > 0) {
            ArsAffinity.LOGGER.debug("Attempting to award initiation advancement to {}", (Object)serverPlayer.getName().getString());
            AffinityAdvancementEvents.award(serverPlayer, INITIATION);
        }
        if ((advancementId = COMPLETION_ADVANCEMENTS.get(school = event.getSchool())) == null) {
            ArsAffinity.LOGGER.warn("No advancement mapped for school {}", (Object)school);
            return;
        }
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
        if (maxPoints > 0 && event.getTotalPoints() >= maxPoints) {
            ArsAffinity.LOGGER.debug("Player {} reached max points ({}/{}) for school {}, awarding mastery advancement", (Object)serverPlayer.getName().getString(), (Object)event.getTotalPoints(), (Object)maxPoints, (Object)school);
            AffinityAdvancementEvents.award(serverPlayer, advancementId);
        }
    }

    private static void award(ServerPlayer player, ResourceLocation advancementId) {
        MinecraftServer server = player.server;
        if (server == null) {
            ArsAffinity.LOGGER.warn("Cannot award advancement {}: server is null", (Object)advancementId);
            return;
        }
        ArsAffinity.LOGGER.debug("Looking up advancement {} for player {}", (Object)advancementId, (Object)player.getName().getString());
        AdvancementHolder advancement = server.getAdvancements().get(advancementId);
        if (advancement == null) {
            ArsAffinity.LOGGER.error("Missing advancement {}! Expected file at: data/{}/advancement/{}.json", (Object)advancementId, (Object)advancementId.getNamespace(), (Object)advancementId.getPath());
            return;
        }
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
        if (progress.isDone()) {
            ArsAffinity.LOGGER.debug("Advancement {} already completed for player {}", (Object)advancementId, (Object)player.getName().getString());
            return;
        }
        ArsAffinity.LOGGER.debug("Awarding advancement {} to player {}", (Object)advancementId, (Object)player.getName().getString());
        for (String criterion : progress.getRemainingCriteria()) {
            player.getAdvancements().award(advancement, criterion);
        }
    }
}

