/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.common.network.ParticleEffectPacket;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ParticleUpdateScheduler {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final ConcurrentHashMap<String, ScheduledFuture<?>> activeUpdates = new ConcurrentHashMap();
    private static volatile boolean isShutdown = false;

    public static void startPositionUpdates(Player player, String schoolId) {
        if (isShutdown) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        String key = serverPlayer.getId() + "_" + schoolId;
        WeakReference<ServerPlayer> playerRef = new WeakReference<ServerPlayer>(serverPlayer);
        ScheduledFuture<?> task = scheduler.scheduleAtFixedRate(() -> {
            if (activeUpdates.get(key) == null) {
                throw new RuntimeException("Task " + key + " was removed from update list without cancelling");
            }
            ServerPlayer refPlayer = (ServerPlayer)playerRef.get();
            if (refPlayer == null || refPlayer.hasDisconnected() || refPlayer.isRemoved() || !refPlayer.isAlive()) {
                ParticleUpdateScheduler.stopPositionUpdates(key);
                return;
            }
            MinecraftServer server = refPlayer.getServer();
            if (server == null) {
                ParticleUpdateScheduler.stopPositionUpdates(key);
                return;
            }
            server.execute(() -> {
                ServerPlayer execPlayer = (ServerPlayer)playerRef.get();
                if (execPlayer == null || execPlayer.hasDisconnected() || execPlayer.isRemoved() || !execPlayer.isAlive()) {
                    ParticleUpdateScheduler.stopPositionUpdates(key);
                    return;
                }
                Vec3 pos = execPlayer.position();
                ParticleEffectPacket updatePacket = new ParticleEffectPacket(execPlayer.getId(), schoolId, pos.x, pos.y, pos.z);
                Networking.sendToNearbyClient(execPlayer.level(), execPlayer.blockPosition(), (CustomPacketPayload)updatePacket);
                ArsAffinity.LOGGER.debug("Sent position update for player {}: ({}, {}, {})", (Object)execPlayer.getName().getString(), (Object)pos.x, (Object)pos.y, (Object)pos.z);
            });
        }, 150L, 150L, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> oldTask = activeUpdates.put(key, task);
        if (oldTask != null) {
            oldTask.cancel(false);
        }
        scheduler.schedule(() -> ParticleUpdateScheduler.stopPositionUpdates(key), 3000L, TimeUnit.MILLISECONDS);
    }

    public static void stopPositionUpdates(Player player, String schoolId) {
        String key = player.getId() + "_" + schoolId;
        ParticleUpdateScheduler.stopPositionUpdates(key);
    }

    public static void stopPositionUpdates(String key) {
        ScheduledFuture<?> task = activeUpdates.remove(key);
        if (task != null) {
            task.cancel(false);
        }
    }

    public static void shutdown() {
        if (isShutdown) {
            return;
        }
        isShutdown = true;
        for (ScheduledFuture<?> task : activeUpdates.values()) {
            task.cancel(false);
        }
        activeUpdates.clear();
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                ArsAffinity.LOGGER.warn("ParticleUpdateScheduler did not terminate within 5 seconds, forcing shutdown");
                scheduler.shutdownNow();
                if (!scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                    ArsAffinity.LOGGER.error("ParticleUpdateScheduler did not terminate after force shutdown");
                }
            }
        }
        catch (InterruptedException e) {
            ArsAffinity.LOGGER.warn("Interrupted while shutting down ParticleUpdateScheduler, forcing shutdown");
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

