/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.capability.WetTicks;
import com.github.ars_affinity.capability.WetTicksCapability;
import com.github.ars_affinity.capability.WetTicksProvider;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PassiveHydrationEvents {
    private static final Map<UUID, Integer> lastFoodLevels = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (player2.level().isClientSide()) {
            return;
        }
        if (player2.tickCount % 20 != 0) {
            return;
        }
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player2);
        if (data == null) {
            return;
        }
        int waterPoints = data.getSchoolPoints(SpellSchools.ELEMENTAL_WATER);
        if (waterPoints == 0) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player2, AffinityPerkType.PASSIVE_HYDRATION)) {
            float amount = AffinityPerkHelper.getPerkAmount(player2, AffinityPerkType.PASSIVE_HYDRATION);
            WetTicks wetTicks = (WetTicks)player2.getCapability(WetTicksCapability.WET_TICKS);
            if (wetTicks == null) {
                return;
            }
            boolean isWet = player2.isInWater() || player2.isInWaterRainOrBubble();
            boolean isOnFire = player2.isOnFire();
            if (isOnFire) {
                player2.removeEffect(ModPotions.HYDRATED_EFFECT);
                wetTicks.resetWetTicks();
                WetTicksProvider.savePlayerWetTicks(player2);
                lastFoodLevels.remove(player2.getUUID());
                return;
            }
            if (isWet) {
                wetTicks.addWetTicks(20);
                int newWetTicks = wetTicks.getWetTicks();
                WetTicksProvider.savePlayerWetTicks(player2);
                PassiveHydrationEvents.applyHydratedEffect(player2, amount, newWetTicks);
            } else {
                if (wetTicks.getWetTicks() > 0) {
                    ArsAffinity.LOGGER.debug("HYDRATION - Player {} is not wet, resetting wet ticks to 0", (Object)player2.getName().getString());
                    wetTicks.resetWetTicks();
                    WetTicksProvider.savePlayerWetTicks(player2);
                }
                if (player2.hasEffect(ModPotions.HYDRATED_EFFECT)) {
                    ArsAffinity.LOGGER.debug("HYDRATION - Player {} is no longer wet, removing Hydrated effect", (Object)player2.getName().getString());
                    player2.removeEffect(ModPotions.HYDRATED_EFFECT);
                    lastFoodLevels.remove(player2.getUUID());
                }
            }
        }
    }

    private static void applyHydratedEffect(Player player, float maxAmplification, int wetTicks) {
        ArsAffinity.LOGGER.debug("HYDRATION - Applying Hydrated effect for player {} - Max amplification: {}, Wet ticks: {}", (Object)player.getName().getString(), (Object)Float.valueOf(maxAmplification), (Object)wetTicks);
        int targetAmplifier = 0;
        if (wetTicks >= 400 && maxAmplification >= 2.0f) {
            targetAmplifier = 2;
        } else if (wetTicks >= 200 && maxAmplification >= 1.0f) {
            targetAmplifier = 1;
        } else if (wetTicks >= 20) {
            targetAmplifier = 0;
        } else {
            return;
        }
        if (targetAmplifier >= 0) {
            boolean needsUpgrade;
            MobEffectInstance currentEffect = player.getEffect(ModPotions.HYDRATED_EFFECT);
            boolean needsEffect = currentEffect == null;
            boolean bl = needsUpgrade = currentEffect != null && currentEffect.getAmplifier() != targetAmplifier;
            if (needsEffect || needsUpgrade) {
                player.addEffect(new MobEffectInstance(ModPotions.HYDRATED_EFFECT, 80, targetAmplifier, false, false, true));
            }
        }
    }
}

