/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import alexthw.ars_elemental.common.glyphs.EffectCharm;
import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.Random;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class PassiveSoulspikeEvents {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        boolean isMeleeAttack;
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity2 = attacker = event.getSource().getEntity() instanceof LivingEntity ? (LivingEntity)event.getSource().getEntity() : null;
        if (attacker == null) {
            return;
        }
        DamageSource source = event.getSource();
        boolean bl = isMeleeAttack = !source.is(DamageTypeTags.IS_PROJECTILE);
        if (!isMeleeAttack) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_SOULSPIKE)) {
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_SOULSPIKE);
            if (RANDOM.nextFloat() < amount) {
                PassiveSoulspikeEvents.applySoulspike(player, attacker, false);
                ArsAffinity.LOGGER.debug("Soulspike (Melee) activated! Player {} reflected anima at attacker {} ({}% chance)", (Object)player.getName().getString(), (Object)attacker.getName().getString(), (Object)((int)(amount * 100.0f)));
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        Level level = projectile.level();
        if (level.isClientSide()) {
            return;
        }
        HitResult rayTraceResult = event.getRayTraceResult();
        if (!(rayTraceResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
        Entity hitEntity = entityHitResult.getEntity();
        if (!(hitEntity instanceof Player)) {
            return;
        }
        Player player = (Player)hitEntity;
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_SOULSPIKE)) {
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_SOULSPIKE);
            float rangedChance = amount * 0.5f;
            if (RANDOM.nextFloat() < rangedChance) {
                LivingEntity attacker;
                LivingEntity livingEntity = attacker = projectile.getOwner() instanceof LivingEntity ? (LivingEntity)projectile.getOwner() : null;
                if (attacker != null) {
                    PassiveSoulspikeEvents.applySoulspike(player, attacker, true);
                    ArsAffinity.LOGGER.debug("Soulspike (Ranged) activated! Player {} reflected anima at attacker {} ({}% chance)", (Object)player.getName().getString(), (Object)attacker.getName().getString(), (Object)((int)(rangedChance * 100.0f)));
                }
            }
        }
    }

    private static void applySoulspike(Player player, LivingEntity attacker, boolean isRanged) {
        ManaCap playerMana = CapabilityRegistry.getMana((LivingEntity)player);
        int amplifier = 0;
        if (playerMana != null) {
            int maxMana = playerMana.getMaxMana();
            amplifier = maxMana / 100;
        }
        if (attacker instanceof Player) {
            attacker.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, amplifier, false, true, true));
        } else {
            try {
                SpellStats spellStats = new SpellStats.Builder().setAmplification((double)amplifier).build();
                SpellContext context = new SpellContext(player.level(), new Spell(new AbstractSpellPart[]{MethodTouch.INSTANCE, EffectCharm.INSTANCE}), (LivingEntity)player, (IWrappedCaster)new PlayerCaster(player));
                SpellResolver resolver = new SpellResolver(context);
                EffectCharm.INSTANCE.onResolveEntity(new EntityHitResult((Entity)attacker), player.level(), (LivingEntity)player, spellStats, context, resolver);
                ArsAffinity.LOGGER.debug("Applied EffectCharm to attacker {} with amplifier {} (player max mana: {})", (Object)attacker.getName().getString(), (Object)amplifier, (Object)(playerMana != null ? playerMana.getMaxMana() : 0));
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Failed to apply EffectCharm to attacker", (Throwable)e);
            }
        }
        ArsAffinity.LOGGER.debug("Applied soulspike to attacker {} with amplifier {} (player max mana: {})", (Object)attacker.getName().getString(), (Object)amplifier, (Object)(playerMana != null ? playerMana.getMaxMana() : 0));
    }
}

