/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;

public class PassiveUnstableSummoningEvents {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onSummonEvent(SummonEvent event) {
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (!(iWrappedCaster instanceof PlayerCaster)) {
            return;
        }
        PlayerCaster playerCaster = (PlayerCaster)iWrappedCaster;
        Player player = playerCaster.player;
        if (event.world.isClientSide()) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_UNSTABLE_SUMMONING)) {
            LivingEntity originalEntity;
            float chance = AffinityPerkHelper.getPerkChance(player, AffinityPerkType.PASSIVE_UNSTABLE_SUMMONING);
            List<String> entities = AffinityPerkHelper.getPerkEntities(player, AffinityPerkType.PASSIVE_UNSTABLE_SUMMONING);
            if (RANDOM.nextFloat() < chance && (originalEntity = event.summon.getLivingEntity()) != null && !entities.isEmpty()) {
                Level level = originalEntity.level();
                double x = originalEntity.getX();
                double y = originalEntity.getY();
                double z = originalEntity.getZ();
                originalEntity.discard();
                String randomEntityId = entities.get(RANDOM.nextInt(entities.size()));
                Optional entityTypeOpt = EntityType.byString((String)randomEntityId);
                if (entityTypeOpt.isPresent()) {
                    EntityType entityType = (EntityType)entityTypeOpt.get();
                    Entity newEntity = entityType.create(level);
                    if (newEntity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)newEntity;
                        livingEntity.setPos(x, y, z);
                        livingEntity.addTag("unstable_summon");
                        livingEntity.setCustomName((Component)Component.literal((String)"Unstable Summon"));
                        level.addFreshEntity((Entity)livingEntity);
                        if (level instanceof ServerLevel) {
                            UnstableSummonTimer timer = new UnstableSummonTimer(livingEntity, 1200);
                            EventQueue.getServerInstance().addEvent((ITimedEvent)timer);
                        }
                        ArsAffinity.LOGGER.debug("Player {} triggered UNSTABLE_SUMMONING perk ({}%) - transformed summon into {}", (Object)player.getName().getString(), (Object)((int)(chance * 100.0f)), (Object)randomEntityId);
                    }
                } else {
                    ArsAffinity.LOGGER.warn("Invalid entity type for UNSTABLE_SUMMONING perk: {}", (Object)randomEntityId);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity().getTags().contains("unstable_summon")) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public static void onLivingExperience(LivingExperienceDropEvent event) {
        if (event.getEntity().getTags().contains("unstable_summon")) {
            event.setDroppedExperience(0);
        }
    }

    private static class UnstableSummonTimer
    implements ITimedEvent {
        private final LivingEntity entity;
        private int ticksLeft;

        public UnstableSummonTimer(LivingEntity entity, int duration) {
            this.entity = entity;
            this.ticksLeft = duration;
        }

        public void tick(boolean serverSide) {
            if (!serverSide) {
                return;
            }
            --this.ticksLeft;
            if (this.ticksLeft <= 0 && !this.entity.isRemoved()) {
                Level level = this.entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleUtil.spawnPoof((ServerLevel)serverLevel, (BlockPos)this.entity.blockPosition());
                }
                this.entity.discard();
            }
        }

        public boolean isExpired() {
            return this.ticksLeft <= 0 || this.entity.isRemoved();
        }
    }
}

