/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AffinityPerkManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AffinityPerk.class, (Object)new AffinityPerkDeserializer()).create();
    private static final Map<SpellSchool, Map<Integer, List<AffinityPerk>>> schoolPerks = new HashMap<SpellSchool, Map<Integer, List<AffinityPerk>>>();
    private static boolean isLoaded = false;

    /*
     * Exception decompiling
     */
    public static synchronized void loadConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadPerkFile(Path rootDir, Path jsonFile) throws IOException {
        String fileName = jsonFile.getFileName().toString();
        if (!fileName.endsWith(".json")) {
            return;
        }
        String schoolName = fileName.replace(".json", "");
        SpellSchool school = AffinityPerkManager.parseSpellSchool(schoolName);
        if (school == null) {
            ArsAffinity.LOGGER.warn("Unknown spell school: {} in file: {}", (Object)schoolName, (Object)jsonFile);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("perks") && jsonObject.get("perks").isJsonArray()) {
                JsonArray perksArray = jsonObject.getAsJsonArray("perks");
                for (JsonElement perkElement : perksArray) {
                    try {
                        JsonObject perkJson = perkElement.getAsJsonObject();
                        JsonObject oldFormatJson = new JsonObject();
                        oldFormatJson.add("perk", perkJson.get("perk"));
                        oldFormatJson.add("isBuff", (JsonElement)(perkJson.get("category").getAsString().equals("PASSIVE") ? new JsonPrimitive(Boolean.valueOf(true)) : new JsonPrimitive(Boolean.valueOf(false))));
                        if (perkJson.has("amount")) {
                            oldFormatJson.add("amount", perkJson.get("amount"));
                        }
                        if (perkJson.has("time")) {
                            oldFormatJson.add("time", perkJson.get("time"));
                        }
                        if (perkJson.has("cooldown")) {
                            oldFormatJson.add("cooldown", perkJson.get("cooldown"));
                        }
                        if (perkJson.has("manaCost")) {
                            oldFormatJson.add("manaCost", perkJson.get("manaCost"));
                        }
                        if (perkJson.has("damage")) {
                            oldFormatJson.add("damage", perkJson.get("damage"));
                        }
                        if (perkJson.has("freezeTime")) {
                            oldFormatJson.add("freezeTime", perkJson.get("freezeTime"));
                        }
                        if (perkJson.has("radius")) {
                            oldFormatJson.add("radius", perkJson.get("radius"));
                        }
                        if (perkJson.has("entities")) {
                            oldFormatJson.add("entities", perkJson.get("entities"));
                        }
                        if (perkJson.has("dashLength")) {
                            oldFormatJson.add("dashLength", perkJson.get("dashLength"));
                        }
                        if (perkJson.has("dashDuration")) {
                            oldFormatJson.add("dashDuration", perkJson.get("dashDuration"));
                        }
                        if (perkJson.has("health")) {
                            oldFormatJson.add("health", perkJson.get("health"));
                        }
                        if (perkJson.has("hunger")) {
                            oldFormatJson.add("hunger", perkJson.get("hunger"));
                        }
                        if (perkJson.has("chance")) {
                            oldFormatJson.add("chance", perkJson.get("chance"));
                        }
                        AffinityPerk perk = (AffinityPerk)GSON.fromJson((JsonElement)oldFormatJson, AffinityPerk.class);
                        int tier = perkJson.get("tier").getAsInt();
                        AffinityPerkManager.addPerk(school, tier, perk);
                    }
                    catch (Exception e) {
                        ArsAffinity.LOGGER.error("Failed to parse perk: {} - {}", (Object)perkElement, (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
        catch (JsonParseException e) {
            String errorMsg = "JSON parsing error in perk file: " + String.valueOf(jsonFile) + " - " + e.getMessage();
            ArsAffinity.LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException("Ars Affinity: " + errorMsg, e);
        }
        catch (Exception e) {
            String errorMsg = "Failed to parse perk file: " + String.valueOf(jsonFile) + " - " + e.getMessage();
            ArsAffinity.LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException("Ars Affinity: " + errorMsg, e);
        }
    }

    private static void addPerk(SpellSchool school, int level, AffinityPerk perk) {
        ArsAffinity.LOGGER.debug("Adding perk: {} for school {} at level {}", (Object)perk.perk, (Object)school.getId(), (Object)level);
        schoolPerks.computeIfAbsent(school, k -> new HashMap()).computeIfAbsent(level, k -> new ArrayList()).add(perk);
    }

    private static SpellSchool parseSpellSchool(String schoolName) {
        return switch (schoolName.toLowerCase()) {
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            case "abjuration" -> SpellSchools.ABJURATION;
            case "conjuration" -> SpellSchools.CONJURATION;
            case "necromancy" -> SpellSchools.NECROMANCY;
            case "manipulation" -> SpellSchools.MANIPULATION;
            default -> null;
        };
    }

    public static AffinityPerk getPerk(SpellSchool school, int tier, AffinityPerkType perkType) {
        Map<Integer, List<AffinityPerk>> schoolPerkMap;
        if (!isLoaded) {
            AffinityPerkManager.loadConfig();
        }
        if ((schoolPerkMap = schoolPerks.get(school)) == null) {
            return null;
        }
        List<AffinityPerk> tierPerks = schoolPerkMap.get(tier);
        if (tierPerks == null) {
            return null;
        }
        for (AffinityPerk perk : tierPerks) {
            if (perk.perk != perkType) continue;
            return perk;
        }
        return null;
    }

    public static AffinityPerk getHighestLevelPerk(SpellSchool school, AffinityPerkType perkType) {
        Map<Integer, List<AffinityPerk>> schoolPerkMap;
        if (!isLoaded) {
            AffinityPerkManager.loadConfig();
        }
        if ((schoolPerkMap = schoolPerks.get(school)) == null) {
            return null;
        }
        int highestTier = -1;
        AffinityPerk highestPerk = null;
        for (Map.Entry<Integer, List<AffinityPerk>> entry : schoolPerkMap.entrySet()) {
            int tier = entry.getKey();
            List<AffinityPerk> tierPerks = entry.getValue();
            for (AffinityPerk perk : tierPerks) {
                if (perk.perk != perkType || tier <= highestTier) continue;
                highestTier = tier;
                highestPerk = perk;
            }
        }
        return highestPerk;
    }

    private static /* synthetic */ boolean lambda$loadConfig$1(Path path) {
        return path.toString().endsWith(".json");
    }

    private static /* synthetic */ boolean lambda$loadConfig$0(Path x$0) {
        return Files.isRegularFile(x$0, new LinkOption[0]);
    }

    private static class AffinityPerkDeserializer
    implements JsonDeserializer<AffinityPerk> {
        private AffinityPerkDeserializer() {
        }

        public AffinityPerk deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return AffinityPerk.fromJson(json, context);
        }
    }
}

