/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.perk.PerkAllocation;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.player.Player;

public class RespecManager {
    public static final int RESPEC_COST_PER_SCHOOL = 5;
    public static final int RESPEC_COST_ALL_SCHOOLS = 20;

    private RespecManager() {
    }

    public static boolean canRespecSchool(Player player, SpellSchool school) {
        return player.experienceLevel >= 5;
    }

    public static boolean canRespecAllSchools(Player player) {
        return player.experienceLevel >= 20;
    }

    public static boolean respecSchool(Player player, SpellSchool school) {
        if (!RespecManager.canRespecSchool(player, school)) {
            ArsAffinity.LOGGER.debug("Player {} cannot afford to respec school {}", (Object)player.getName().getString(), (Object)school.getId());
            return false;
        }
        PlayerAffinityData affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (affinityData == null) {
            ArsAffinity.LOGGER.warn("PlayerAffinityData not found for player {}", (Object)player.getName().getString());
            return false;
        }
        Map<String, PerkAllocation> allocatedPerks = affinityData.getPerksForSchool(school);
        if (allocatedPerks.isEmpty()) {
            ArsAffinity.LOGGER.debug("No perks allocated for school {} - nothing to respec", (Object)school.getId());
            return false;
        }
        int totalPointsToReturn = 0;
        for (PerkAllocation allocation : allocatedPerks.values()) {
            totalPointsToReturn += allocation.getPointsInvested();
        }
        for (String nodeId : allocatedPerks.keySet()) {
            affinityData.deallocatePerk(nodeId);
        }
        affinityData.addAvailablePoints(school, totalPointsToReturn);
        player.giveExperienceLevels(-5);
        affinityData.setDirty(true);
        ArsAffinity.LOGGER.debug("Player {} respecced school {} - returned {} points, cost {} levels", (Object)player.getName().getString(), (Object)school.getId(), (Object)totalPointsToReturn, (Object)5);
        return true;
    }

    public static boolean respecAllSchools(Player player) {
        if (!RespecManager.canRespecAllSchools(player)) {
            ArsAffinity.LOGGER.debug("Player {} cannot afford to respec all schools", (Object)player.getName().getString());
            return false;
        }
        PlayerAffinityData affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (affinityData == null) {
            ArsAffinity.LOGGER.warn("PlayerAffinityData not found for player {}", (Object)player.getName().getString());
            return false;
        }
        Set<PerkAllocation> allAllocatedPerks = affinityData.getAllAllocatedPerks();
        if (allAllocatedPerks.isEmpty()) {
            ArsAffinity.LOGGER.debug("No perks allocated - nothing to respec");
            return false;
        }
        HashMap<SpellSchool, Integer> pointsToReturn = new HashMap<SpellSchool, Integer>();
        for (PerkAllocation perkAllocation : allAllocatedPerks) {
            SpellSchool school = perkAllocation.getNode().getSchool();
            pointsToReturn.merge(school, perkAllocation.getPointsInvested(), Integer::sum);
        }
        for (PerkAllocation perkAllocation : allAllocatedPerks) {
            affinityData.deallocatePerk(perkAllocation.getNodeId());
        }
        for (Map.Entry entry : pointsToReturn.entrySet()) {
            affinityData.addAvailablePoints((SpellSchool)entry.getKey(), (Integer)entry.getValue());
        }
        player.giveExperienceLevels(-20);
        affinityData.setDirty(true);
        ArsAffinity.LOGGER.debug("Player {} respecced all schools - returned {} total points, cost {} levels", (Object)player.getName().getString(), (Object)pointsToReturn.values().stream().mapToInt(Integer::intValue).sum(), (Object)20);
        return true;
    }

    public static int getRespecCost(SpellSchool school) {
        return 5;
    }

    public static int getRespecAllCost() {
        return 20;
    }
}

