/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.util;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.config.ArsAffinityConfig;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class GlyphBlacklistHelper {
    public static boolean isGlyphBlacklisted(AbstractSpellPart glyph) {
        if (glyph == null) {
            return false;
        }
        try {
            ResourceLocation registryName = glyph.getRegistryName();
            if (registryName == null) {
                ArsAffinity.LOGGER.debug("Glyph has no registry name, cannot check blacklist");
                return false;
            }
            String glyphId = registryName.toString();
            List blacklist = (List)ArsAffinityConfig.GLYPH_BLACKLIST.get();
            if (blacklist == null || blacklist.isEmpty()) {
                return false;
            }
            boolean isBlacklisted = blacklist.contains(glyphId);
            if (isBlacklisted) {
                ArsAffinity.LOGGER.debug("Glyph {} is blacklisted from affinity tracking", (Object)glyphId);
            }
            return isBlacklisted;
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error checking if glyph is blacklisted: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isGlyphIdBlacklisted(String glyphId) {
        if (glyphId == null || glyphId.isEmpty()) {
            return false;
        }
        try {
            List blacklist = (List)ArsAffinityConfig.GLYPH_BLACKLIST.get();
            if (blacklist == null || blacklist.isEmpty()) {
                return false;
            }
            boolean isBlacklisted = blacklist.contains(glyphId);
            if (isBlacklisted) {
                ArsAffinity.LOGGER.debug("Glyph ID {} is blacklisted from affinity tracking", (Object)glyphId);
            }
            return isBlacklisted;
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error checking if glyph ID {} is blacklisted: {}", (Object)glyphId, (Object)e.getMessage());
            return false;
        }
    }

    public static void logBlacklistConfiguration() {
        try {
            List blacklist = (List)ArsAffinityConfig.GLYPH_BLACKLIST.get();
            if (blacklist == null || blacklist.isEmpty()) {
                ArsAffinity.LOGGER.debug("Glyph blacklist is empty - no glyphs are blacklisted");
            } else {
                ArsAffinity.LOGGER.debug("Glyph blacklist contains {} entries:", (Object)blacklist.size());
                for (String glyphId : blacklist) {
                    ArsAffinity.LOGGER.debug("  - {}", (Object)glyphId);
                }
            }
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error logging blacklist configuration: {}", (Object)e.getMessage());
        }
    }
}

